/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.render.ElementRenderer;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.radar.tracker.PlayerTrackerIconRenderer;
import xaero.map.radar.tracker.PlayerTrackerMapElement;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderContext;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderProvider;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderer;
import xaero.map.radar.tracker.PlayerTrackerMenuRenderContext;

public final class PlayerTrackerMenuRenderer
extends MapElementMenuRenderer<PlayerTrackerMapElement<?>, PlayerTrackerMenuRenderContext> {
    private final PlayerTrackerIconRenderer iconRenderer;
    private final PlayerTrackerMapElementRenderer renderer;
    private Button showPlayersButton;

    private PlayerTrackerMenuRenderer(PlayerTrackerMapElementRenderer renderer, PlayerTrackerIconRenderer iconRenderer, PlayerTrackerMenuRenderContext context, PlayerTrackerMapElementRenderProvider<PlayerTrackerMenuRenderContext> provider) {
        super(context, provider);
        this.iconRenderer = iconRenderer;
        this.renderer = renderer;
    }

    @Override
    public void onMapInit(GuiMap screen, Minecraft mc, int width, int height) {
        super.onMapInit(screen, mc, width, height);
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean trackedPlayers = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_TRACKED_PLAYERS);
        Tooltip showPlayersTooltip = new Tooltip((Component)new TranslatableComponent(trackedPlayers ? "gui.xaero_box_showing_tracked_players" : "gui.xaero_box_hiding_tracked_players", new Object[]{new TextComponent(KeyMappingUtils.getKeyName((KeyMapping)screen.getTrackedPlayerKeyBinding())).m_130938_(s -> s.m_131140_(ChatFormatting.DARK_GREEN))}), true);
        this.showPlayersButton = new GuiTexturedButton(width - 173, height - 33, 20, 20, trackedPlayers ? 197 : 213, 48, 16, 16, WorldMap.guiTextures, b -> this.onShowPlayersButton(screen, width, height), () -> showPlayersTooltip);
        screen.addButton(this.showPlayersButton);
        this.showPlayersButton.f_93623_ = !WorldMapClientConfigUtils.isOptionServerEnforced((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.DISPLAY_TRACKED_PLAYERS);
    }

    public void onShowPlayersButton(GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.tryTogglingCurrentProfileOption((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.DISPLAY_TRACKED_PLAYERS);
        screen.m_6575_(this.mc, width, height);
        screen.m_7522_((GuiEventListener)this.showPlayersButton);
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }

    @Override
    public void renderInMenu(PlayerTrackerMapElement<?> element, PoseStack matrixStack, Screen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed, int textX) {
        PlayerTrackerMapElement<?> playerElement = element;
        PlayerInfo info = mc.m_91403_().m_104949_(playerElement.getPlayerId());
        if (info != null) {
            Player clientPlayer = mc.f_91073_.m_46003_(playerElement.getPlayerId());
            this.iconRenderer.renderIcon(matrixStack, clientPlayer, this.renderer.getTrackedPlayerIconManager().getPlayerSkin(clientPlayer, info));
        }
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 1;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_players_by_name";
    }

    @Override
    protected ElementRenderer<? super PlayerTrackerMapElement<?>, ?, ?> getRenderer(PlayerTrackerMapElement<?> element) {
        return this.renderer;
    }

    public boolean canJumpTo(PlayerTrackerMapElement<?> element) {
        return !this.renderer.getReader().isHidden(element, (PlayerTrackerMapElementRenderContext)this.renderer.getContext());
    }

    public static final class Builder {
        private PlayerTrackerMapElementRenderer renderer;

        private Builder() {
        }

        private Builder setDefault() {
            this.setRenderer(null);
            return this;
        }

        public Builder setRenderer(PlayerTrackerMapElementRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public PlayerTrackerMenuRenderer build() {
            if (this.renderer == null) {
                throw new IllegalStateException();
            }
            return new PlayerTrackerMenuRenderer(this.renderer, new PlayerTrackerIconRenderer(), new PlayerTrackerMenuRenderContext(), new PlayerTrackerMapElementRenderProvider<PlayerTrackerMenuRenderContext>(this.renderer.getCollector()));
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

