/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.capabilities.CapabilityGetter;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.executor.Executor;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.region.MapRegion;
import xaero.map.world.MapWorld;

public class WorldDataHandler {
    private final Executor renderExecutor;
    private WorldDataReader reader;
    private ServerLevel worldServer;
    private Path worldDir;

    public WorldDataHandler(WorldDataReader reader, Executor renderExecutor) throws NoSuchFieldException, SecurityException {
        this.reader = reader;
        this.renderExecutor = renderExecutor;
    }

    public void handleRenderExecutor() {
        this.renderExecutor.m_18699_();
    }

    public void prepareSingleplayer(Level world, MapProcessor mapProcessor) {
        MapWorld mapWorld = mapProcessor.getMapWorld();
        if (world != null && mapWorld.getCurrentDimension().isUsingWorldSave()) {
            ResourceKey<Level> dimId = mapWorld.getCurrentDimensionId();
            this.worldServer = Minecraft.m_91087_().m_91092_().m_129880_(dimId);
            if (this.worldServer != null) {
                Path overworldDir = this.worldServer.m_142572_().m_129843_(LevelResource.f_78182_);
                this.worldDir = DimensionType.m_196975_(dimId, (Path)overworldDir);
            } else {
                this.worldDir = null;
            }
        } else {
            this.worldServer = null;
            this.worldDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result buildRegion(MapRegion region, boolean loading, int[] chunkCountDest) throws IOException {
        ServerWorldCapabilities serverCaps;
        if (this.worldServer == null) {
            WorldMap.LOGGER.info("Tried loading a region for a null server world!");
            return Result.CANCEL;
        }
        try {
            serverCaps = CapabilityGetter.getServerWorldCapabilities(this.worldServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        boolean shouldCancel = false;
        ServerWorldCapabilities serverWorldCapabilities = serverCaps;
        synchronized (serverWorldCapabilities) {
            if (serverCaps.loaded) {
                boolean buildResult = this.reader.buildRegion(region, this.worldServer, loading, chunkCountDest, this.renderExecutor);
                Result result = buildResult ? Result.SUCCESS : Result.FAIL;
                return result;
            }
            shouldCancel = true;
        }
        if (shouldCancel) {
            WorldMap.LOGGER.info("Tried loading a region for an unloaded server world!");
            return Result.CANCEL;
        }
        WorldMap.LOGGER.info("Server world capability required for Xaero's World Map not present!");
        return Result.FAIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onServerWorldUnload(ServerLevel sw) {
        ServerWorldCapabilities serverCaps;
        try {
            serverCaps = CapabilityGetter.getServerWorldCapabilities(sw);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ServerWorldCapabilities serverWorldCapabilities = serverCaps;
        synchronized (serverWorldCapabilities) {
            serverCaps.loaded = false;
        }
    }

    public ServerLevel getWorldServer() {
        return this.worldServer;
    }

    public WorldDataReader getWorldDataReader() {
        return this.reader;
    }

    public Path getWorldDir() {
        return this.worldDir;
    }

    Executor getWorldDataRenderExecutor() {
        return this.renderExecutor;
    }

    public static enum Result {
        SUCCESS,
        FAIL,
        CANCEL;

    }
}

