/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ImplementedContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.IAttunementItem;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WarpPlateBlock;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.Waystone;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.item.AttunedShardItem;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.menu.WarpPlateContainer;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class WarpPlateBlockEntity
extends WaystoneBlockEntityBase
implements ImplementedContainer {
    private final WeakHashMap<Entity, Integer> ticksPassedPerEntity = new WeakHashMap();
    private final Random random = new Random();
    private final ContainerData dataAccess;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    private int attunementTicks;
    private boolean readyForAttunement;
    private boolean completedFirstAttunement;
    private int lastAttunementSlot;

    public WarpPlateBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.warpPlate.get(), blockPos, blockState);
        this.dataAccess = new ContainerData(){

            public int m_6413_(int i) {
                return WarpPlateBlockEntity.this.attunementTicks;
            }

            public void m_8050_(int i, int j) {
                WarpPlateBlockEntity.this.attunementTicks = j;
            }

            public int m_6499_() {
                return 1;
            }
        };
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public ItemStack m_7407_(int slot, int count) {
        if (!this.completedFirstAttunement) {
            return ItemStack.f_41583_;
        }
        return super.m_7407_(slot, count);
    }

    public ItemStack m_8016_(int slot) {
        if (!this.completedFirstAttunement) {
            return ItemStack.f_41583_;
        }
        return super.m_8016_(slot);
    }

    @Override
    public void initializeFromExisting(ServerLevelAccessor world, Waystone existingWaystone, ItemStack itemStack) {
        super.initializeFromExisting(world, existingWaystone, itemStack);
        CompoundTag tag = itemStack.m_41783_();
        boolean bl = this.completedFirstAttunement = tag != null && tag.m_128471_("CompletedFirstAttunement");
        if (!this.completedFirstAttunement) {
            this.initializeInventory();
        }
    }

    @Override
    public void initializeWaystone(ServerLevelAccessor world, @Nullable LivingEntity player, boolean wasGenerated) {
        super.initializeWaystone(world, player, wasGenerated);
        IWaystone waystone = this.getWaystone();
        if (waystone instanceof IMutableWaystone) {
            String name = NameGenerator.get(world.m_142572_()).getName(waystone, world.m_5822_(), NameGenerationMode.RANDOM_ONLY);
            ((IMutableWaystone)((Object)waystone)).setName(name);
        }
        WaystoneSyncManager.sendWaystoneUpdateToAll(world.m_142572_(), waystone);
        this.initializeInventory();
    }

    private void initializeInventory() {
        this.m_6836_(0, new ItemStack((ItemLike)Items.f_42484_));
        this.m_6836_(1, new ItemStack((ItemLike)ModItems.warpDust));
        this.m_6836_(2, new ItemStack((ItemLike)ModItems.warpDust));
        this.m_6836_(3, new ItemStack((ItemLike)ModItems.warpDust));
        this.m_6836_(4, new ItemStack((ItemLike)ModItems.warpDust));
    }

    @Override
    protected ResourceLocation getWaystoneType() {
        return WaystoneTypes.WARP_PLATE;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        tag.m_128379_("ReadyForAttunement", this.readyForAttunement);
        tag.m_128379_("CompletedFirstAttunement", this.completedFirstAttunement);
        tag.m_128405_("LastAttunementSlot", this.lastAttunementSlot);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        ContainerHelper.m_18980_((CompoundTag)compound, this.items);
        this.readyForAttunement = compound.m_128471_("ReadyForAttunement");
        this.completedFirstAttunement = compound.m_128471_("CompletedFirstAttunement");
        this.lastAttunementSlot = compound.m_128451_("LastAttunementSlot");
    }

    public BalmMenuProvider getMenuProvider() {
        return new BalmMenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent("container.waystones.warp_plate");
            }

            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player player) {
                return new WarpPlateContainer(i, WarpPlateBlockEntity.this, WarpPlateBlockEntity.this.dataAccess, playerInventory);
            }

            public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                buf.m_130064_(WarpPlateBlockEntity.this.f_58858_);
            }
        };
    }

    @Override
    public MenuProvider getSettingsMenuProvider() {
        return null;
    }

    public void onEntityCollision(Entity entity) {
        Integer ticksPassed = this.ticksPassedPerEntity.putIfAbsent(entity, 0);
        if (ticksPassed == null || ticksPassed != -1) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)WarpPlateBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    private boolean isEntityOnWarpPlate(Entity entity) {
        return entity.m_20185_() >= (double)this.f_58858_.m_123341_() && entity.m_20185_() < (double)(this.f_58858_.m_123341_() + 1) && entity.m_20186_() >= (double)this.f_58858_.m_123342_() && entity.m_20186_() < (double)(this.f_58858_.m_123342_() + 1) && entity.m_20189_() >= (double)this.f_58858_.m_123343_() && entity.m_20189_() < (double)(this.f_58858_.m_123343_() + 1);
    }

    public void serverTick() {
        AABB boundsAbove;
        List entities;
        if (this.isReadyForAttunement()) {
            ++this.attunementTicks;
            if (this.attunementTicks >= this.getMaxAttunementTicks()) {
                this.attunementTicks = 0;
                ItemStack attunedShard = new ItemStack((ItemLike)ModItems.attunedShard);
                AttunedShardItem.setWaystoneAttunedTo(attunedShard, this.getWaystone());
                this.m_6836_(0, attunedShard);
                for (int i = 1; i <= 4; ++i) {
                    this.m_6836_(i, ItemStack.f_41583_);
                }
                this.completedFirstAttunement = true;
            }
        } else {
            this.attunementTicks = 0;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)WarpPlateBlock.ACTIVE)).booleanValue() && (entities = this.f_58857_.m_6249_((Entity)null, boundsAbove = new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1)), EntitySelector.f_20402_)).isEmpty()) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)WarpPlateBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
            this.ticksPassedPerEntity.clear();
        }
        int useTime = this.getWarpPlateUseTime();
        Iterator<Map.Entry<Entity, Integer>> iterator = this.ticksPassedPerEntity.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Entity, Integer> entry = iterator.next();
            Entity entity = entry.getKey();
            Integer ticksPassed = entry.getValue();
            if (!entity.m_6084_() || !this.isEntityOnWarpPlate(entity)) {
                iterator.remove();
                continue;
            }
            if (ticksPassed > useTime) {
                IWaystone targetWaystone = this.getTargetWaystone();
                if (targetWaystone != null && targetWaystone.isValid()) {
                    this.teleportToWarpPlate(entity, targetWaystone);
                }
                if (entity instanceof Player) {
                    if (targetWaystone == null) {
                        chatComponent = new TranslatableComponent("chat.waystones.warp_plate_has_no_target");
                        chatComponent.m_130940_(ChatFormatting.DARK_RED);
                        ((Player)entity).m_5661_((Component)chatComponent, true);
                    } else if (!targetWaystone.isValid()) {
                        chatComponent = new TranslatableComponent("chat.waystones.warp_plate_has_invalid_target");
                        chatComponent.m_130940_(ChatFormatting.DARK_RED);
                        ((Player)entity).m_5661_((Component)chatComponent, true);
                    }
                }
                iterator.remove();
                continue;
            }
            if (ticksPassed == -1) continue;
            entry.setValue(ticksPassed + 1);
        }
        if (this.m_8020_(0).m_41720_() != Items.f_42484_) {
            this.completedFirstAttunement = true;
        }
    }

    private int getWarpPlateUseTime() {
        float useTimeMultiplier = 1.0f;
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41720_() == Items.f_151049_) {
                useTimeMultiplier -= 0.016f * (float)itemStack.m_41613_();
                continue;
            }
            if (itemStack.m_41720_() != Items.f_42518_) continue;
            useTimeMultiplier += 0.016f * (float)itemStack.m_41613_();
        }
        int configuredUseTime = WaystonesConfig.getActive().cooldowns.warpPlateUseTime;
        return Mth.m_14045_((int)((int)((float)configuredUseTime * useTimeMultiplier)), (int)1, (int)(configuredUseTime * 2));
    }

    private void teleportToWarpPlate(Entity entity, IWaystone targetWaystone) {
        PlayerWaystoneManager.tryTeleportToWaystone(entity, targetWaystone, WarpMode.WARP_PLATE, this.getWaystone()).ifLeft(entities -> entities.forEach(this::applyWarpPlateEffects));
    }

    private void applyWarpPlateEffects(Entity entity) {
        int fireSeconds = 0;
        int poisonSeconds = 0;
        int blindSeconds = 0;
        int featherFallSeconds = 0;
        int fireResistanceSeconds = 0;
        int witherSeconds = 0;
        int potency = 1;
        ArrayList<ItemStack> curativeItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41720_() == Items.f_42593_) {
                fireSeconds += itemStack.m_41613_();
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42675_) {
                poisonSeconds += itemStack.m_41613_();
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42532_) {
                blindSeconds += itemStack.m_41613_();
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42455_ || itemStack.m_41720_() == Items.f_42788_) {
                curativeItems.add(itemStack);
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42415_) {
                potency = Math.min(4, potency + itemStack.m_41613_());
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42402_) {
                featherFallSeconds = Math.min(8, featherFallSeconds + itemStack.m_41613_());
                continue;
            }
            if (itemStack.m_41720_() == Items.f_42542_) {
                fireResistanceSeconds = Math.min(8, fireResistanceSeconds + itemStack.m_41613_());
                continue;
            }
            if (itemStack.m_41720_() != Items.f_41951_) continue;
            witherSeconds += itemStack.m_41613_();
        }
        if (entity instanceof LivingEntity) {
            if (fireSeconds > 0) {
                entity.m_20254_(fireSeconds);
            }
            if (poisonSeconds > 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, poisonSeconds * 20, potency));
            }
            if (blindSeconds > 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19610_, blindSeconds * 20, potency));
            }
            if (featherFallSeconds > 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19591_, featherFallSeconds * 20, potency));
            }
            if (fireResistanceSeconds > 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19607_, fireResistanceSeconds * 20, potency));
            }
            if (witherSeconds > 0) {
                ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19615_, witherSeconds * 20, potency));
            }
            for (ItemStack curativeItem : curativeItems) {
                Balm.getHooks().curePotionEffects((LivingEntity)entity, curativeItem);
            }
        }
    }

    private boolean isReadyForAttunement() {
        return this.readyForAttunement && this.m_8020_(0).m_41720_() == Items.f_42484_ && this.m_8020_(1).m_41720_() == ModItems.warpDust && this.m_8020_(2).m_41720_() == ModItems.warpDust && this.m_8020_(3).m_41720_() == ModItems.warpDust && this.m_8020_(4).m_41720_() == ModItems.warpDust;
    }

    @Nullable
    public IWaystone getTargetWaystone() {
        boolean useRoundRobin = false;
        ArrayList<ItemStack> attunedShards = new ArrayList<ItemStack>();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41720_() instanceof IAttunementItem) {
                IWaystone waystoneAttunedTo = ((IAttunementItem)itemStack.m_41720_()).getWaystoneAttunedTo(this.f_58857_.m_142572_(), itemStack);
                if (waystoneAttunedTo == null || waystoneAttunedTo.getWaystoneUid().equals(this.getWaystone().getWaystoneUid())) continue;
                attunedShards.add(itemStack);
                continue;
            }
            if (itemStack.m_41720_() != Items.f_42692_) continue;
            useRoundRobin = true;
        }
        if (!attunedShards.isEmpty()) {
            this.lastAttunementSlot = (this.lastAttunementSlot + 1) % attunedShards.size();
            ItemStack itemStack = useRoundRobin ? (ItemStack)attunedShards.get(this.lastAttunementSlot) : (ItemStack)attunedShards.get(this.random.nextInt(attunedShards.size()));
            return ((IAttunementItem)itemStack.m_41720_()).getWaystoneAttunedTo(this.f_58857_.m_142572_(), itemStack);
        }
        return null;
    }

    public int getMaxAttunementTicks() {
        return 30;
    }

    public void markReadyForAttunement() {
        this.readyForAttunement = true;
    }

    public void markEntityForCooldown(Entity entity) {
        this.ticksPassedPerEntity.put(entity, -1);
    }

    public boolean isCompletedFirstAttunement() {
        return this.completedFirstAttunement;
    }

    public ContainerData getContainerData() {
        return this.dataAccess;
    }
}

