/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining.logic;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.StructureBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import top.theillusivec4.veinmining.VeinMiningMod;
import top.theillusivec4.veinmining.config.VeinMiningConfig;
import top.theillusivec4.veinmining.veinmining.VeinMiningPlayers;
import top.theillusivec4.veinmining.veinmining.logic.BlockProcessor;

public class VeinMiningLogic {
    private static final Direction[] CARDINAL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH};

    public static void veinMine(ServerPlayer playerEntity, BlockPos pos, Block source) {
        boolean ineffective;
        ServerLevel world = playerEntity.m_183503_();
        ItemStack stack = playerEntity.m_21205_();
        BlockState state = world.m_8055_(pos);
        boolean bl = ineffective = VeinMiningConfig.VeinMining.requireEffectiveTool && !ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)playerEntity);
        if (ineffective) {
            return;
        }
        int veiningLevels = EnchantmentHelper.m_44843_((Enchantment)VeinMiningMod.VEIN_MINING, (ItemStack)stack);
        int maxBlocks = VeinMiningConfig.VeinMining.maxBlocksBase + VeinMiningConfig.VeinMining.maxBlocksPerLevel * veiningLevels;
        int maxDistance = VeinMiningConfig.VeinMining.maxDistanceBase + VeinMiningConfig.VeinMining.maxDistancePerLevel * veiningLevels;
        if (maxBlocks <= 0 || maxDistance <= 0) {
            return;
        }
        int blocks = 1;
        HashSet visited = Sets.newHashSet((Object[])new BlockPos[]{pos});
        LinkedList<Tuple<BlockPos, Integer>> candidates = new LinkedList<Tuple<BlockPos, Integer>>();
        VeinMiningLogic.addValidNeighbors(candidates, pos, 1);
        while (!candidates.isEmpty() && blocks < maxBlocks) {
            Tuple<BlockPos, Integer> candidate = candidates.poll();
            BlockPos blockPos = (BlockPos)candidate.m_14418_();
            int blockDistance = (Integer)candidate.m_14419_();
            if (VeinMiningLogic.stopVeining(stack)) {
                return;
            }
            BlockState blockState = world.m_8055_(blockPos);
            if (!visited.add(blockPos) || !BlockProcessor.isValidTarget(blockState, (Level)world, blockPos, source) || !VeinMiningLogic.harvest(playerEntity, blockPos, pos)) continue;
            if (blockDistance < maxDistance) {
                VeinMiningLogic.addValidNeighbors(candidates, blockPos, blockDistance + 1);
            }
            ++blocks;
        }
    }

    private static boolean stopVeining(ItemStack stack) {
        return stack.m_41763_() && VeinMiningConfig.VeinMining.limitedByDurability && (stack.m_41773_() == stack.m_41776_() || VeinMiningConfig.VeinMining.preventToolDestruction && stack.m_41773_() == stack.m_41776_() - 1);
    }

    private static void addValidNeighbors(LinkedList<Tuple<BlockPos, Integer>> candidates, BlockPos source, int distance) {
        if (VeinMiningConfig.VeinMining.diagonalMining) {
            BlockPos[] blockPositions;
            BlockPos up = source.m_7494_();
            BlockPos down = source.m_7495_();
            candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)up, (Object)distance));
            candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)down, (Object)distance));
            for (BlockPos blockPos : blockPositions = new BlockPos[]{up, down, source}) {
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142125_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142126_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142127_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142128_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142127_().m_142125_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142127_().m_142126_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142128_().m_142125_(), (Object)distance));
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)blockPos.m_142128_().m_142126_(), (Object)distance));
            }
        } else {
            for (Direction direction : CARDINAL_DIRECTIONS) {
                candidates.add((Tuple<BlockPos, Integer>)new Tuple((Object)source.m_142300_(direction), (Object)distance));
            }
        }
    }

    public static boolean harvest(ServerPlayer player, BlockPos pos, BlockPos originPos) {
        ServerLevel world = player.m_183503_();
        BlockState blockstate = world.m_8055_(pos);
        GameType gameType = player.f_8941_.m_9290_();
        int exp = ForgeHooks.onBlockBreakEvent((Level)world, (GameType)gameType, (ServerPlayer)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        Block block = blockstate.m_60734_();
        if ((block instanceof CommandBlock || block instanceof StructureBlock || block instanceof JigsawBlock) && !player.m_36337_()) {
            world.m_7260_(pos, blockstate, blockstate, 3);
            return false;
        }
        if (player.m_21205_().onBlockStartBreak(pos, (Player)player)) {
            return true;
        }
        if (player.m_36187_((Level)world, pos, gameType)) {
            return false;
        }
        if (gameType.m_46408_()) {
            VeinMiningLogic.removeBlock((Player)player, pos, false);
        } else {
            BlockPos spawnPos;
            ItemStack itemstack = player.m_21205_();
            ItemStack itemstack1 = itemstack.m_41777_();
            boolean flag1 = blockstate.canHarvestBlock((BlockGetter)world, pos, (Player)player);
            itemstack.m_41686_((Level)world, blockstate, pos, (Player)player);
            if (itemstack.m_41619_() && !itemstack1.m_41619_()) {
                ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)itemstack1, (InteractionHand)InteractionHand.MAIN_HAND);
            }
            boolean flag = VeinMiningLogic.removeBlock((Player)player, pos, flag1);
            BlockPos blockPos = spawnPos = VeinMiningConfig.VeinMining.relocateDrops ? originPos : pos;
            if (flag && flag1) {
                FoodData foodData = player.m_36324_();
                float currentExhaustion = foodData.m_150380_();
                VeinMiningPlayers.addMiningBlock((Level)world, pos, spawnPos);
                block.m_6240_((Level)world, (Player)player, pos, blockstate, tileentity, itemstack1);
                VeinMiningPlayers.removeMiningBlock((Level)world, pos);
                if (VeinMiningConfig.VeinMining.addPlayerExhaustion) {
                    float diff = foodData.m_150380_() - currentExhaustion;
                    foodData.m_150378_(currentExhaustion);
                    foodData.m_38703_((float)((double)diff * VeinMiningConfig.VeinMining.playerExhaustionMultiplier));
                } else {
                    foodData.m_150378_(currentExhaustion);
                }
            }
            if (flag && exp > 0) {
                blockstate.m_60734_().m_49805_(world, spawnPos, exp);
            }
        }
        return true;
    }

    private static boolean removeBlock(Player player, BlockPos pos, boolean canHarvest) {
        Level world = player.m_20193_();
        BlockState state = world.m_8055_(pos);
        boolean removed = state.onDestroyedByPlayer(world, pos, player, canHarvest, world.m_6425_(pos));
        if (removed) {
            state.m_60734_().m_6786_((LevelAccessor)world, pos, state);
            if (!world.m_8055_(pos).m_60795_()) {
                world.m_7471_(pos, false);
            }
        }
        return removed;
    }
}

