/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining.logic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import top.theillusivec4.veinmining.config.VeinMiningConfig;
import top.theillusivec4.veinmining.veinmining.logic.BlockGroups;

public class BlockProcessor {
    private static final Map<String, Boolean> checkedBlocks = new HashMap<String, Boolean>();
    private static final Map<String, Map<String, Boolean>> checkedPairs = new HashMap<String, Map<String, Boolean>>();
    private static final Map<String, Set<String>> checkedTags = new HashMap<String, Set<String>>();

    public static synchronized void rebuild() {
        checkedBlocks.clear();
        checkedPairs.clear();
        checkedTags.clear();
        BlockGroups.init();
    }

    public static boolean isValidTarget(BlockState state, Level world, BlockPos pos, Block source) {
        Block block = state.m_60734_();
        return !state.m_60795_() && checkedBlocks.computeIfAbsent(Objects.requireNonNull(block.getRegistryName()).toString(), name -> BlockProcessor.checkBlock(state)) != false && BlockProcessor.matches(source, block);
    }

    private static boolean matches(Block origin, Block target) {
        String targetName;
        boolean useOriginKey;
        if (origin == target) {
            return true;
        }
        String originName = Objects.requireNonNull(origin.getRegistryName()).toString();
        boolean bl = useOriginKey = originName.compareTo(targetName = Objects.requireNonNull(target.getRegistryName()).toString()) >= 0;
        if (useOriginKey) {
            return checkedPairs.computeIfAbsent(originName, name -> new HashMap()).computeIfAbsent(targetName, name -> BlockProcessor.checkMatch(origin, target));
        }
        return checkedPairs.computeIfAbsent(targetName, name -> new HashMap()).computeIfAbsent(originName, name -> BlockProcessor.checkMatch(origin, target));
    }

    private static boolean checkBlock(BlockState blockState) {
        HashSet<String> ids = new HashSet<String>();
        String blockId = Objects.requireNonNull(blockState.m_60734_().getRegistryName()).toString();
        ids.add(blockId);
        Set tags = checkedTags.computeIfAbsent(blockId, name -> BlockProcessor.getTagsFor(blockState));
        tags.forEach(tag -> ids.add("#" + tag));
        Set<String> configs = VeinMiningConfig.VeinMining.blocks;
        if (VeinMiningConfig.VeinMining.blocksPermission == VeinMiningConfig.PermissionType.BLACKLIST) {
            for (String id : configs) {
                if (!ids.contains(id)) continue;
                return false;
            }
            return true;
        }
        for (String id : configs) {
            if (!ids.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getTagsFor(BlockState blockState) {
        HashSet<String> tags = new HashSet<String>();
        Registry.f_122824_.m_203613_().forEach(blockTagKey -> {
            if (blockState.m_204336_(blockTagKey)) {
                tags.add(blockTagKey.f_203868_().toString());
            }
        });
        return tags;
    }

    private static boolean checkMatch(Block origin, Block target) {
        Set<String> group = BlockGroups.getGroup(Objects.requireNonNull(origin.getRegistryName()).toString());
        if (group != null) {
            return group.contains(Objects.requireNonNull(target.getRegistryName()).toString());
        }
        return false;
    }
}

