/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.veinmining.veinmining;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class VeinMiningPlayers {
    private static final long DIFF = 20L;
    private static final Map<UUID, Long> ACTIVATED_MINERS = new HashMap<UUID, Long>();
    private static final Set<UUID> CURRENT_MINERS = new HashSet<UUID>();
    private static final Map<Level, Map<BlockPos, BlockPos>> MINING_BLOCKS = new HashMap<Level, Map<BlockPos, BlockPos>>();

    public static void validate(long worldTime) {
        Iterator<Map.Entry<UUID, Long>> entries = ACTIVATED_MINERS.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<UUID, Long> entry = entries.next();
            long lastTime = entry.getValue();
            if (worldTime - lastTime <= 20L && lastTime <= worldTime) continue;
            entries.remove();
        }
    }

    public static boolean canStartVeinMining(Player player) {
        return ACTIVATED_MINERS.containsKey(player.m_142081_());
    }

    public static void activateVeinMining(Player player, long time) {
        ACTIVATED_MINERS.put(player.m_142081_(), time);
    }

    public static void deactivateVeinMining(Player player) {
        ACTIVATED_MINERS.remove(player.m_142081_());
    }

    public static boolean isVeinMining(Player player) {
        return CURRENT_MINERS.contains(player.m_142081_());
    }

    public static void startVeinMining(Player player) {
        CURRENT_MINERS.add(player.m_142081_());
    }

    public static void stopVeinMining(Player player) {
        CURRENT_MINERS.remove(player.m_142081_());
    }

    public static void addMiningBlock(Level level, BlockPos pos, BlockPos spawnPos) {
        MINING_BLOCKS.computeIfAbsent(level, k -> new HashMap()).put(pos, spawnPos);
    }

    public static void removeMiningBlock(Level level, BlockPos pos) {
        Map<BlockPos, BlockPos> map = MINING_BLOCKS.get(level);
        if (map != null) {
            map.remove(pos);
        }
    }

    public static Optional<BlockPos> getNewSpawnPosForDrop(Level level, BlockPos pos) {
        Map<BlockPos, BlockPos> map = MINING_BLOCKS.get(level);
        if (map != null) {
            return Optional.ofNullable(map.get(pos));
        }
        return Optional.empty();
    }
}

