/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import ovh.corail.tombstone.enchantment.EnchantmentBlessing;
import ovh.corail.tombstone.enchantment.EnchantmentCurseOfBones;
import ovh.corail.tombstone.enchantment.EnchantmentFrostbite;
import ovh.corail.tombstone.enchantment.EnchantmentMagicSiphon;
import ovh.corail.tombstone.enchantment.EnchantmentPlagueBringer;
import ovh.corail.tombstone.enchantment.EnchantmentSoulBound;
import ovh.corail.tombstone.enchantment.EnchantmentSpectralBite;
import ovh.corail.tombstone.enchantment.EnchantmentSpectralConjurer;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.Registrable;

@ObjectHolder(value="tombstone")
@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModEnchantments {
    public static final Enchantment soulbound = (Enchantment)Helper.unsafeNullCast();
    public static final Enchantment magic_siphon = (Enchantment)Helper.unsafeNullCast();
    public static final Enchantment plague_bringer = (Enchantment)Helper.unsafeNullCast();
    public static final Enchantment curse_of_bones = (Enchantment)Helper.unsafeNullCast();
    public static final Enchantment blessing = (Enchantment)Helper.unsafeNullCast();
    public static final Enchantment frostbite = (Enchantment)Helper.unsafeNullCast();
    public static final Enchantment spectral_bite = (Enchantment)Helper.unsafeNullCast();
    public static final Enchantment spectral_conjurer = (Enchantment)Helper.unsafeNullCast();
    private static final Map<String, TombstoneEnchantment> ENCHANTMENTS = new HashMap<String, TombstoneEnchantment>();

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), new EnchantmentSoulBound(), "soulbound");
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), new EnchantmentMagicSiphon(), "magic_siphon");
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), new EnchantmentPlagueBringer(), "plague_bringer");
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), new EnchantmentCurseOfBones(), "curse_of_bones");
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), new EnchantmentBlessing(), "blessing");
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), new EnchantmentFrostbite(), "frostbite");
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), new EnchantmentSpectralBite(), "spectral_bite");
        ModEnchantments.registerEnchantment((IForgeRegistry<Enchantment>)event.getRegistry(), new EnchantmentSpectralConjurer(), "spectral_conjurer");
    }

    private static void registerEnchantment(IForgeRegistry<Enchantment> registry, TombstoneEnchantment enchantment, String name) {
        Registrable.register(registry, enchantment, name);
        ENCHANTMENTS.put(Objects.requireNonNull(enchantment.getRegistryName()).toString(), enchantment);
    }

    public static Map<String, TombstoneEnchantment> getEnchantments() {
        return ENCHANTMENTS;
    }
}

