/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.perk;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;

public final class PerkShadowWalker
extends Perk {
    public PerkShadowWalker() {
        super("shadow_walker", new ResourceLocation("tombstone", "textures/mob_effect/discretion.png"));
    }

    @Override
    public int getLevelMax() {
        return (Integer)SharedConfigTombstone.allowed_perks.levelMaxShadowWalker.get();
    }

    @Override
    public boolean isDisabled(@Nullable Player player) {
        return (Boolean)SharedConfigTombstone.allowed_perks.allowShadowWalker.get() == false;
    }

    @Override
    public List<Component> getCurrentBonusInfo(int level) {
        ArrayList<Component> bonus = new ArrayList<Component>();
        bonus.add((Component)new TextComponent("+" + level * 10 + "% ").m_7220_((Component)new TranslatableComponent(this.getTranslationKey() + ".bonus1")));
        if (level > 4) {
            bonus.add((Component)new TranslatableComponent(this.getTranslationKey() + ".bonus2"));
        }
        return bonus;
    }

    @Override
    public int getLevelBonus(Player player) {
        int bonus;
        int n = bonus = player.m_6844_(EquipmentSlot.HEAD).m_41720_() == ModItems.rabbit_mask ? 2 : 0;
        if (TimeHelper.isDateAroundChristmas()) {
            bonus += 3;
        }
        return bonus;
    }
}

