/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.SoulType;
import ovh.corail.tombstone.particle.CustomParticle;
import ovh.corail.tombstone.particle.ParticleBlinkingAura;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleGraveSoul
extends CustomParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/particle/soul.png");
    private static final double RADIUS = 0.3;
    private static final double SECTION = 1.5707963705062866;
    private final double centerX;
    private final double centerY;
    private final double centerZ;
    private final int part;

    public ParticleGraveSoul(ClientLevel level, double centerX, double centerY, double centerZ, int soulTypeId, int part) {
        super(level, centerX, centerY, centerZ);
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
        this.part = part;
        this.m_107257_(25);
        this.m_6569_(soulTypeId > 1 ? 0.2f : 0.15f);
        this.withColor(SoulType.byId(soulTypeId).getColorCode());
        this.m_107271_(0.5f);
        this.updatePosition();
        this.updateLastPos();
    }

    @Override
    protected void updatePosition() {
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        double ratio = (double)this.f_107224_ / (double)this.f_107225_;
        Vec3 vec = new Vec3(this.centerX + 0.3 * Math.cos(1.5707963705062866 * (ratio + (double)this.part)), this.centerY, this.centerZ + 0.3 * Math.sin(1.5707963705062866 * (ratio + (double)this.part)));
        this.m_107264_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    @Override
    public void update() {
        super.update();
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)new ParticleBlinkingAura(this.f_107208_, this.f_107212_, this.f_107213_ + 0.02, this.f_107214_, this.f_107227_, this.f_107228_, this.f_107229_));
    }

    @Override
    protected ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }
}

