/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.particle;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.particle.BoundParticle;

@OnlyIn(value=Dist.CLIENT)
public final class ParticleCasting
extends BoundParticle {
    private static final ResourceLocation COMMON_TEXTURE = new ResourceLocation("tombstone", "textures/particle/casting.png");
    private final Predicate<LivingEntity> requireRemoval;

    public ParticleCasting(ClientLevel level, LivingEntity caster, Predicate<LivingEntity> requireRemoval) {
        super(level, caster, 1.1);
        this.requireRemoval = requireRemoval;
        this.setRolling(0.15707964f);
        this.withColor((Integer)ConfigTombstone.client.particleCastingColor.get());
    }

    @Override
    protected void addParticleDatas(List<BoundParticle.ParticleData> datas) {
        int count = 6;
        double addY = 0.4;
        for (int part = 0; part < 6; ++part) {
            datas.add(new CastingData(this.f_107208_.f_46441_.nextFloat() * 0.3f + 0.5f, (double)(Helper.RANDOM.nextFloat() * (float)Math.PI), addY, 0.0f));
            datas.add(new CastingData(this.f_107208_.f_46441_.nextFloat() * 0.3f + 0.5f, (double)((1.0f + Helper.RANDOM.nextFloat()) * (float)Math.PI), addY, (float)Math.PI));
            addY += 0.25;
        }
    }

    @Override
    protected void onParticleDataUpdate(BoundParticle.ParticleData data, double ratio) {
        CastingData castingData = (CastingData)data;
        if (castingData.yHeight > 2.0 || castingData.yHeight < 0.2) {
            castingData.goUp = !castingData.goUp;
        }
        castingData.yHeight = castingData.yHeight + (castingData.goUp ? 0.02 : -0.02);
        super.onParticleDataUpdate(data, ratio);
    }

    @Override
    protected boolean requireRemoval() {
        return Optional.ofNullable((LivingEntity)this.entityWeakReference.get()).map(this.requireRemoval::test).orElse(true);
    }

    @Override
    protected ResourceLocation getTexture() {
        return COMMON_TEXTURE;
    }

    private class CastingData
    extends BoundParticle.ParticleData {
        private boolean goUp;

        protected CastingData(float size, double angle, double yHeight, float startRoll) {
            super(size, angle, yHeight, startRoll);
            this.goUp = yHeight < 1.0;
        }
    }
}

