/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.perk.PerkRegistry;

public final class CMessageTBCapability {
    private final SyncType syncType;
    private int knowledge;
    private int alignment;
    private int level;
    private Map<Perk, Integer> perks;
    private Perk perk;

    public CMessageTBCapability(SyncType syncType, int knowledge, int alignment, Map<Perk, Integer> perks) {
        this.syncType = syncType;
        if (this.syncType == SyncType.ALL) {
            this.knowledge = Math.max(0, knowledge);
            this.alignment = alignment;
            this.perks = perks;
        }
    }

    public CMessageTBCapability(SyncType syncType, int knowledge, int alignment) {
        this.syncType = syncType;
        if (this.syncType == SyncType.KNOWLEDGE_AND_ALIGNMENT) {
            this.knowledge = Math.max(0, knowledge);
            this.alignment = alignment;
        }
    }

    public CMessageTBCapability(SyncType syncType, int value) {
        this.syncType = syncType;
        if (this.syncType == SyncType.KNOWLEDGE) {
            this.knowledge = Math.max(0, value);
        } else if (this.syncType == SyncType.ALIGNMENT) {
            this.alignment = value;
        }
    }

    public CMessageTBCapability(SyncType syncType, Map<Perk, Integer> perks) {
        this.syncType = syncType;
        if (this.syncType == SyncType.PERKS) {
            this.perks = perks;
        }
    }

    public CMessageTBCapability(SyncType syncType, Perk perk, int level) {
        this.syncType = syncType;
        if (this.syncType == SyncType.SET_PERK) {
            this.perk = perk;
            this.level = level;
        }
    }

    public CMessageTBCapability(SyncType syncType, Perk perk) {
        this.syncType = syncType;
        if (this.syncType == SyncType.REMOVE_PERK) {
            this.perk = perk;
        }
    }

    static CMessageTBCapability fromBytes(FriendlyByteBuf buf) {
        return switch (SyncType.values()[buf.readByte()]) {
            default -> throw new IncompatibleClassChangeError();
            case SyncType.ALL -> new CMessageTBCapability(SyncType.ALL, buf.readInt(), buf.readShort(), CMessageTBCapability.readPerks(buf.m_130260_()));
            case SyncType.KNOWLEDGE_AND_ALIGNMENT -> new CMessageTBCapability(SyncType.KNOWLEDGE_AND_ALIGNMENT, buf.readInt(), (int)buf.readShort());
            case SyncType.KNOWLEDGE -> new CMessageTBCapability(SyncType.KNOWLEDGE, buf.readInt());
            case SyncType.ALIGNMENT -> new CMessageTBCapability(SyncType.ALIGNMENT, buf.readShort());
            case SyncType.PERKS -> new CMessageTBCapability(SyncType.PERKS, CMessageTBCapability.readPerks(buf.m_130260_()));
            case SyncType.SET_PERK -> new CMessageTBCapability(SyncType.SET_PERK, (Perk)PerkRegistry.get().getValue((int)buf.readShort()), buf.readByte() & 0xFF);
            case SyncType.REMOVE_PERK -> new CMessageTBCapability(SyncType.REMOVE_PERK, (Perk)PerkRegistry.get().getValue((int)buf.readShort()));
        };
    }

    private static Map<Perk, Integer> readPerks(CompoundTag tag) {
        HashMap<Perk, Integer> perks = new HashMap<Perk, Integer>();
        if (tag != null) {
            NBTStackHelper.readPerks(perks, tag);
        }
        return perks;
    }

    static void toBytes(CMessageTBCapability msg, FriendlyByteBuf buf) {
        buf.writeByte(msg.syncType.ordinal());
        switch (msg.syncType) {
            case ALL: {
                buf.writeInt(msg.knowledge);
                buf.writeShort(msg.alignment);
                CompoundTag tag = new CompoundTag();
                NBTStackHelper.writePerks(msg.perks, tag);
                buf.m_130079_(tag);
                break;
            }
            case KNOWLEDGE_AND_ALIGNMENT: {
                buf.writeInt(msg.knowledge);
                buf.writeShort(msg.alignment);
                break;
            }
            case KNOWLEDGE: {
                buf.writeInt(msg.knowledge);
                break;
            }
            case ALIGNMENT: {
                buf.writeShort(msg.alignment);
                break;
            }
            case PERKS: {
                CompoundTag tag = new CompoundTag();
                NBTStackHelper.writePerks(msg.perks, tag);
                buf.m_130079_(tag);
                break;
            }
            case SET_PERK: {
                buf.writeShort(PerkRegistry.get().getID((IForgeRegistryEntry)msg.perk));
                buf.writeByte(msg.level);
                break;
            }
            case REMOVE_PERK: {
                buf.writeShort(PerkRegistry.get().getID((IForgeRegistryEntry)msg.perk));
            }
        }
    }

    public static enum SyncType {
        ALL,
        KNOWLEDGE_AND_ALIGNMENT,
        KNOWLEDGE,
        ALIGNMENT,
        PERKS,
        SET_PERK,
        REMOVE_PERK;

    }

    public static class Handler {
        static void handle(final CMessageTBCapability message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        Player player = ModTombstone.PROXY.getClientPlayer();
                        if (player != null) {
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
                                switch (message2.syncType) {
                                    case ALL: {
                                        cap.setKnowledge(message2.knowledge);
                                        cap.setAlignment(message2.alignment);
                                        cap.setPerks(message2.perks);
                                        break;
                                    }
                                    case KNOWLEDGE_AND_ALIGNMENT: {
                                        cap.setKnowledge(message2.knowledge);
                                        cap.setAlignment(message2.alignment);
                                        break;
                                    }
                                    case KNOWLEDGE: {
                                        cap.setKnowledge(message2.knowledge);
                                        break;
                                    }
                                    case ALIGNMENT: {
                                        cap.setAlignment(message2.alignment);
                                        break;
                                    }
                                    case PERKS: {
                                        cap.setPerks(message2.perks);
                                        break;
                                    }
                                    case SET_PERK: {
                                        cap.setPerk(message2.perk, message2.level);
                                        break;
                                    }
                                    case REMOVE_PERK: {
                                        cap.removePerk(message2.perk);
                                    }
                                }
                            });
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

