/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemLostTablet
extends ItemGraveMagic {
    private static final String ROLL_NBT_SHORT = "roll";
    private static final String TYPE_NBT_SHORT = "type";
    private static final String ID_NBT_STRING = "id";
    private static final String POSITION_NBT_LOCATION = "position";

    public ItemLostTablet() {
        super("lost_tablet", () -> SharedConfigTombstone.allowed_magic_items.allowLostTablet.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        Type type = this.getType(stack);
        String id = type.isUnknown() ? "1" : (this.isEnchanted(stack) ? "3" : "2");
        this.addItemDesc(tooltip, id, new Object[0]);
        if (!type.isUnknown()) {
            this.getLocationId(stack).ifPresent(rl -> tooltip.add(type == Type.EXPLORATION ? Helper.getBiomeName(rl) : SupportStructures.getStructureName(rl)));
            this.addItemPosition(tooltip, this.getLocation(stack));
        }
        this.addItemUse(tooltip, id, new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (stack.m_150930_((Item)this) && EntityHelper.isValidServerPlayer(entity) && !this.isWakeUp(stack)) {
            int cd;
            ServerPlayer player = (ServerPlayer)entity;
            int roll = NBTStackHelper.getShort(stack, ROLL_NBT_SHORT, (short)-1);
            if (roll == -1) {
                roll = Helper.RANDOM.nextInt(100) + EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.treasure_seeker) * 10;
                NBTStackHelper.setShort(stack, ROLL_NBT_SHORT, (short)roll);
            }
            if ((cd = this.getCooldown(level, stack)) <= 0) {
                this.setCooldown(level, stack, TimeHelper.tickFromSecond(500 + Helper.RANDOM.nextInt(301)));
            } else if (cd == 1) {
                if (this.wakeUpMagic(player, stack, Type.get(roll))) {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_SUCCESS.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[0]);
                } else if (Helper.RANDOM.nextInt(5) != 0) {
                    this.setCooldown(level, stack, TimeHelper.tickFromSecond(1500 + Helper.RANDOM.nextInt(301)));
                } else {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_FAILED.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[0]);
                    stack.m_41774_(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.grave_dust, Helper.RANDOM.nextInt(4) + 2));
                    player.f_36095_.m_38946_();
                    ModTriggers.GRAVE_DUST_FROM_BREAKING_TABLET.trigger(player);
                }
            }
        }
    }

    @Override
    public int getCooldown(@Nullable Level level, ItemStack stack) {
        return level != null && stack.m_150930_((Item)this) ? NBTStackHelper.getTimer(TimeHelper.worldTicks(level), stack, "cooldown_time", TimeHelper.tickFromSecond(1800)) : 0;
    }

    private boolean wakeUpMagic(ServerPlayer player, ItemStack stack, Type type) {
        ResourceLocation structureRL;
        Location location;
        ServerLevel level = player.m_183503_();
        if (type == Type.EXPLORATION) {
            location = new Location(Helper.getCloserValidPos((Level)level, player.m_142538_().m_142022_(Helper.RANDOM.nextGaussian() * 5000.0 + 500.0, 0.0, Helper.RANDOM.nextGaussian() * 5000.0 + 500.0)), (Level)level);
            structureRL = level.m_204166_(location.getPos()).m_203543_().map(ResourceKey::m_135782_).orElse(null);
        } else {
            HolderSet<ConfiguredStructureFeature<?, ?>> holderSet;
            if (type == Type.VILLAGE) {
                holderSet = SupportStructures.VILLAGE.asHolderSet(level);
            } else {
                holderSet = (Boolean)ConfigTombstone.magic_item.lostTabletSearchModdedStructure.get() != false ? SupportStructures.getRandomStructure(level, rl -> !SupportStructures.VILLAGE.is((ResourceLocation)rl) && !Helper.containRL((List<String>)((List)ConfigTombstone.magic_item.lostTabletDeniedStructures.get()), rl)) : SupportStructures.getRandomVanillaStructure(level, supportStructures -> supportStructures != SupportStructures.VILLAGE);
                if (holderSet == null) {
                    type = Type.VILLAGE;
                    holderSet = SupportStructures.VILLAGE.asHolderSet(level);
                }
            }
            Optional structureHolder = holderSet.m_203450_(Helper.RANDOM);
            HolderSet biomes = structureHolder.map(Holder::m_203334_).map(ConfiguredStructureFeature::m_209752_).orElse(null);
            ResourceLocation rl2 = structureHolder.map(Holder::m_203543_).filter(Optional::isPresent).map(Optional::get).map(ResourceKey::m_135782_).orElse(null);
            if (biomes == null || rl2 == null) {
                return false;
            }
            if (((Boolean)ConfigTombstone.magic_item.lostTabletSearchOutsideWorld.get()).booleanValue() && (!SupportStructures.hasStructureInWorld(level, rl2, (HolderSet<Biome>)biomes) || Helper.RANDOM.nextFloat() < 0.3f)) {
                level = Helper.getRandomInList(SupportStructures.getPossibleWorlds(level.m_142572_(), rl2, (HolderSet<Biome>)biomes)).orElse(level);
            }
            Pair<Location, ResourceLocation> res = Helper.findNearestStructure(level, player.m_142538_().m_142022_(Helper.RANDOM.nextGaussian() * 2000.0, 0.0, Helper.RANDOM.nextGaussian() * 2000.0), holderSet, true);
            location = (Location)res.getLeft();
            structureRL = (ResourceLocation)res.getRight();
        }
        if (structureRL == null || location.isOrigin() || !Helper.isValidPos((Level)level, location.getPos())) {
            return false;
        }
        NBTStackHelper.setShort(stack, TYPE_NBT_SHORT, (short)type.ordinal());
        NBTStackHelper.setString(stack, ID_NBT_STRING, structureRL.toString());
        NBTStackHelper.setLocation(stack, POSITION_NBT_LOCATION, location);
        stack.m_41749_(ROLL_NBT_SHORT);
        switch (type) {
            case EXPLORATION: {
                ModTriggers.FIND_LOST_TABLET_EXPLORATION.trigger(player);
                break;
            }
            case VILLAGE: {
                ModTriggers.FIND_LOST_TABLET_VILLAGE.trigger(player);
                break;
            }
            case TREASURE: {
                ModTriggers.FIND_LOST_TABLET_TREASURE.trigger(player);
            }
        }
        return true;
    }

    public Optional<String> getLocationId(ItemStack stack) {
        String id;
        if (stack.m_150930_((Item)this) && !(id = NBTStackHelper.getString(stack, ID_NBT_STRING)).isEmpty()) {
            return Optional.of(id);
        }
        return Optional.empty();
    }

    public boolean isWakeUp(ItemStack stack) {
        return stack.m_150930_((Item)this) && !this.getType(stack).isUnknown();
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return super.canEnchant(level, gravePos, player, stack) && this.isWakeUp(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.isWakeUp(stack) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (this.isWakeUp(stack)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        Holder holder;
        Location location = this.getLocation(stack);
        Optional<String> id = this.getLocationId(stack);
        if (id.isEmpty() || location.isOrigin()) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((Player)player, new Object[0]);
            this.resetStack((Level)level, stack);
            return false;
        }
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !location.isSameDimension((Level)level)) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        ServerLevel targetWorld = Objects.requireNonNull(player.m_20194_()).m_129880_(location.dim);
        if (!Helper.isValidPos((Level)targetWorld, location.getPos())) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((Player)player, new Object[0]);
            this.resetStack((Level)level, stack);
            return false;
        }
        Location spawnLoc = new SpawnHelper(targetWorld, location.getPos()).findStructurePlace(id.get());
        if (spawnLoc.isOrigin()) {
            LangKey.MESSAGE_NO_SPAWN.sendMessage((Player)player, new Object[0]);
            this.resetStack((Level)level, stack);
            return false;
        }
        EntityHelper.setGlobalItemCooldown((Player)player, this, 10);
        NBTStackHelper.removeKeyName(stack, "enchant");
        NBTStackHelper.setLocation(stack, POSITION_NBT_LOCATION, spawnLoc);
        if (this.getType(stack) == Type.EXPLORATION && !(holder = level.m_204166_(spawnLoc.getPos())).m_203373_(new ResourceLocation(id.get()))) {
            holder.m_203543_().ifPresent(k -> NBTStackHelper.setString(stack, ID_NBT_STRING, k.toString()));
        }
        CallbackHandler.addFastCallback(() -> {
            ServerPlayer newPlayer = Helper.teleport(player, spawnLoc, targetWorld);
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newPlayer, new Object[0]);
            ModTriggers.USE_LOST_TABLET.trigger(newPlayer);
        });
        return true;
    }

    private void resetStack(Level level, ItemStack stack) {
        this.setCooldown(level, stack, TimeHelper.tickFromMinute(10));
        NBTStackHelper.removeKeyName(stack, "enchant", TYPE_NBT_SHORT, ID_NBT_STRING);
        NBTStackHelper.removeLocation(stack, POSITION_NBT_LOCATION);
    }

    public Location getLocation(ItemStack stack) {
        return stack.m_150930_((Item)this) ? NBTStackHelper.getLocation(stack, POSITION_NBT_LOCATION) : Location.ORIGIN;
    }

    @Override
    protected int getCastingCooldown() {
        return 0;
    }

    @Override
    protected int getUseMax() {
        return 1;
    }

    @Override
    protected boolean canConsumeOnUse() {
        return false;
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_(ROLL_NBT_SHORT)) {
            CompoundTag tag = stack.m_41783_().m_6426_();
            tag.m_128473_(ROLL_NBT_SHORT);
            return tag;
        }
        return stack.m_41783_();
    }

    public Type getType(ItemStack stack) {
        return Type.byId(NBTStackHelper.getShort(stack, TYPE_NBT_SHORT));
    }

    public static enum Type {
        UNKNOWN,
        EXPLORATION,
        VILLAGE,
        TREASURE;


        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public static Type get(int roll) {
            return roll < 40 ? EXPLORATION : (roll < 70 ? VILLAGE : TREASURE);
        }

        private static Type byId(short id) {
            return id >= Type.values().length ? UNKNOWN : Type.values()[Math.max(0, id)];
        }
    }
}

