/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfDisenchantment
extends ItemBook {
    public ItemBookOfDisenchantment() {
        super("book_of_disenchantment", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfDisenchantment.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        boolean isEnchantedBook;
        ItemStack mainhand;
        if (stack.m_41720_() != this || (mainhand = player.m_21205_()).m_41619_()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_FAILED.getText(new Object[0]));
        }
        boolean bl = isEnchantedBook = mainhand.m_41720_() == Items.f_42690_;
        if (isEnchantedBook && !((Boolean)ConfigTombstone.magic_item.canDisenchantEnchantedBook.get()).booleanValue()) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_DENIED_ITEM.getText(new TranslatableComponent(Items.f_42690_.m_5671_(mainhand)).m_6270_(StyleType.TOOLTIP_ITEM)));
        }
        boolean isTetraModular = SupportMods.TETRA.isLoaded() && Optional.ofNullable(mainhand.m_41720_().getRegistryName()).map(r -> r.m_135827_().equals(SupportMods.TETRA.m_7912_()) && r.m_135815_().startsWith("modular_")).orElse(false) != false;
        Map<Enchantment, Integer> enchantments = this.getDeserializedEnchantments(mainhand);
        if (enchantments.size() == 0) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_NO_ENCHANTMENT.getText(new Object[0]));
        }
        if (isEnchantedBook && enchantments.size() == 1) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_DISENCHANTMENT_FAILED.getText(new Object[0]));
        }
        Iterator<Map.Entry<Enchantment, Integer>> it = enchantments.entrySet().iterator();
        stack.m_41774_(1);
        int enchantMax = isTetraModular ? Integer.MAX_VALUE : EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.scribe) + 2;
        int enchantCount = 0;
        while (enchantCount < enchantMax && it.hasNext()) {
            Map.Entry<Enchantment, Integer> entry = it.next();
            if (entry.getKey() == null || entry.getValue() == null) continue;
            ItemStack book = new ItemStack((ItemLike)Items.f_42690_);
            HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
            map.put(entry.getKey(), entry.getValue());
            EnchantmentHelper.m_44865_(map, (ItemStack)book);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)book);
            it.remove();
            ++enchantCount;
        }
        int left = enchantments.size();
        if (isEnchantedBook) {
            mainhand.m_41774_(1);
            if (left > 0) {
                ItemStack oldEnchantedBook = new ItemStack((ItemLike)Items.f_42690_);
                EnchantmentHelper.m_44865_(enchantments, (ItemStack)oldEnchantedBook);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)oldEnchantedBook);
            }
        } else {
            if (left == 0) {
                if (mainhand.m_41788_()) {
                    mainhand.m_41742_(1);
                } else {
                    mainhand.m_41749_("RepairCost");
                }
            }
            if (isTetraModular) {
                CompoundTag tag = mainhand.m_41784_();
                tag.m_128473_("Enchantments");
                tag.m_128473_("StoredEnchantments");
                tag.m_128473_("EnchantmentMapping");
                tag.m_128359_("id", UUID.randomUUID().toString());
            }
            EnchantmentHelper.m_44865_(enchantments, (ItemStack)mainhand);
        }
        ModTriggers.USE_DISENCHANTMENT.trigger(player);
        return ISoulConsumer.ConsumeResult.success((Component)(left == 0 || isEnchantedBook && left == 1 ? LangKey.MESSAGE_DISENCHANTMENT_SUCCESS.getText(new Object[0]) : LangKey.MESSAGE_DISENCHANTMENT_PARTIAL_SUCCESS.getText(left)), 1);
    }
}

