/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ServerLevelAccessor;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.ServantEntityImpl;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEntities;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class PrayerHelper {
    public static boolean exorcism(ServerPlayer player, LivingEntity target, int alignment) {
        if (target instanceof ZombieVillager) {
            ZombieVillager zombieVillager = (ZombieVillager)target;
            return Optional.ofNullable((Villager)zombieVillager.m_21406_(EntityType.f_20492_, false)).map(villager -> {
                villager.m_141967_(zombieVillager.m_7141_());
                if (zombieVillager.f_34361_ != null) {
                    villager.m_35455_(zombieVillager.f_34361_);
                }
                if (zombieVillager.f_34362_ != null) {
                    villager.m_35476_(new MerchantOffers(zombieVillager.f_34362_));
                }
                villager.m_35546_(zombieVillager.m_149889_());
                villager.m_6518_((ServerLevelAccessor)player.m_183503_(), player.m_183503_().m_6436_(villager.m_142538_()), MobSpawnType.CONVERSION, null, null);
                CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 3, (Integer)ConfigTombstone.alignment.pointsExorcismZombieVillager.get()));
                Helper.damageItem(player.m_21205_(), 3, player, InteractionHand.MAIN_HAND);
                LangKey.MESSAGE_EXORCISM.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                ModTriggers.EXORCISM.trigger(player);
                return true;
            }).orElse(false);
        }
        return false;
    }

    public static boolean isValidUndead(Entity entity) {
        PathfinderMob target;
        return entity instanceof PathfinderMob && EntityHelper.isUndead((LivingEntity)(target = (PathfinderMob)entity)) && entity.m_6095_() != ModEntities.grave_guardian && entity.m_6095_() != ModEntities.spectral_wolf && !EntityHelper.isBoss((LivingEntity)target);
    }

    public static boolean undead(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment < -1 && PrayerHelper.isValidUndead((Entity)target) && player.m_183503_().m_46791_() != Difficulty.PEACEFUL) {
            return target.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).filter(cap -> {
                Optional<UUID> ownerId = cap.getOwnerId();
                return ownerId.isEmpty() || !player.m_36316_().getId().equals(ownerId.get());
            }).map(cap -> {
                cap.setOwnerId(player.m_36316_().getId());
                if (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.necromancer) * 10) {
                    cap.setSpellCaster(ServantEntityImpl.CasterType.getRandomId());
                }
                cap.setAI((PathfinderMob)target);
                CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                Helper.damageItem(player.m_21205_(), 5, player, InteractionHand.MAIN_HAND);
                LangKey.MESSAGE_PRAYER_OF_UNDEAD.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                ModTriggers.PRAYER_OF_UNDEAD.trigger(player);
                return true;
            }).orElse(false);
        }
        return false;
    }

    public static boolean zombify(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment < 0 && target instanceof Villager) {
            Villager villager = (Villager)target;
            if (player.m_183503_().m_46791_() != Difficulty.PEACEFUL) {
                return Optional.ofNullable((ZombieVillager)villager.m_21406_(EntityType.f_20530_, false)).map(zombieVillager -> {
                    zombieVillager.m_6518_((ServerLevelAccessor)player.m_183503_(), player.m_183503_().m_6436_(zombieVillager.m_142538_()), MobSpawnType.CONVERSION, null, null);
                    zombieVillager.m_141967_(villager.m_7141_());
                    zombieVillager.m_34391_((Tag)villager.m_35517_().m_26179_((DynamicOps)NbtOps.f_128958_).getValue());
                    zombieVillager.m_34411_(villager.m_6616_().m_45388_());
                    zombieVillager.m_34373_(villager.m_7809_());
                    zombieVillager.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).ifPresent(cap -> {
                        cap.setOwnerId(player.m_36316_().getId());
                        if (Helper.RANDOM.nextInt(100) <= EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.necromancer) * 10) {
                            cap.setSpellCaster(ServantEntityImpl.CasterType.getRandomId());
                        }
                        cap.setAI((PathfinderMob)zombieVillager);
                    });
                    CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                    player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 3, -((Integer)ConfigTombstone.alignment.pointsExorcismZombieVillager.get()).intValue()));
                    Helper.damageItem(player.m_21205_(), 3, player, InteractionHand.MAIN_HAND);
                    LangKey.MESSAGE_EXORCISM.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
                    ModTriggers.ZOMBIFY.trigger(player);
                    return true;
                }).orElse(false);
            }
        }
        return false;
    }

    public static boolean empathy(ServerPlayer player, LivingEntity target, int alignment) {
        TamableType tamableType;
        if (alignment > 1 && (tamableType = TamableType.getType((Entity)target)) != null) {
            TamableType.setTamedBy((Player)player, (Entity)target);
            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
            Helper.damageItem(player.m_21205_(), 5, player, InteractionHand.MAIN_HAND);
            LangKey.MESSAGE_PRAY_OF_EMPATHY.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[0]);
            if (tamableType == TamableType.TAMABLE) {
                player.f_19853_.m_7605_((Entity)target, (byte)7);
            }
            ModTriggers.PRAYER_OF_EMPATHY.trigger(player);
            return true;
        }
        return false;
    }

    public static boolean protection(ServerPlayer player, LivingEntity target, int alignment) {
        if (alignment > 0) {
            return target.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).map(protCap -> {
                if (!protCap.isActive()) {
                    protCap.apply(target, true);
                    if (target instanceof ServerPlayer) {
                        EntityHelper.syncProtectedPlayerCapability(player);
                    }
                    CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                    player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 3, (Integer)ConfigTombstone.alignment.pointsPrayOfProtection.get()));
                    Helper.damageItem(player.m_21205_(), 3, player, InteractionHand.MAIN_HAND);
                    LangKey.MESSAGE_PRAY_OF_PROTECTION_SUCCESS.sendMessage((Player)player, StyleType.MESSAGE_SPECIAL, new Object[]{target.m_7755_()});
                    ModTriggers.PRAY_OF_PROTECTION.trigger(player);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public static void onGrave(ServerPlayer player, BlockPos position) {
        BlockPos gravePos = Helper.findGraveAround(player.f_19853_, position);
        boolean valid = false;
        if (gravePos != null) {
            valid = player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> {
                CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                cap.reward(player, 1, 0);
                Helper.damageItem(player.m_21205_(), 1, player, InteractionHand.MAIN_HAND);
                ModTriggers.PRAY_ON_GRAVE.trigger(player);
                if (TimeHelper.isAprilFoolsDay()) {
                    EffectHelper.addEffect((LivingEntity)player, MobEffects.f_19594_, TimeHelper.tickFromDay(1));
                } else if (EffectHelper.clearEffect((LivingEntity)player, MobEffects.f_19594_)) {
                    LangKey.MESSAGE_DISPEL_BAD_OMEN.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[0]);
                }
                int totalPerkPoints = cap.getTotalPerkPoints();
                int chancePet = Helper.RANDOM.nextInt(100);
                if (chancePet <= (TimeHelper.isAprilFoolsDay() ? 30 : totalPerkPoints / 5)) {
                    EntityType.m_20632_((String)TamableType.getRandomTamableEntityTypeString()).ifPresent(entityType -> {
                        Entity pet = entityType.m_20615_(player.f_19853_);
                        if (pet != null) {
                            pet.m_6034_((double)((float)gravePos.m_123341_() + Helper.RANDOM.nextFloat()) - 0.5, (double)gravePos.m_123342_() + 1.0, (double)((float)gravePos.m_123343_() + Helper.RANDOM.nextFloat()) - 0.5);
                            if (pet instanceof Mob) {
                                ((Mob)pet).m_6518_((ServerLevelAccessor)player.m_183503_(), player.f_19853_.m_6436_(pet.m_142538_()), MobSpawnType.MOB_SUMMONED, null, null);
                            }
                            TamableType.setTamedBy((Player)player, pet);
                            player.f_19853_.m_7967_(pet);
                            LangKey.MESSAGE_SUMMON_FAMILIAR.sendMessage((Player)player, new Object[0]);
                        }
                    });
                }
                if (TimeHelper.isDateAroundHalloween() || Helper.RANDOM.nextInt(100) <= (Integer)ConfigTombstone.decorative_grave.chancePrayReward.get() + totalPerkPoints) {
                    EffectHelper.addRandomEffect((Player)player, (Integer)SharedConfigTombstone.decorative_grave.cooldownToPray.get() * 5000, true, false, false);
                }
                return true;
            }).orElse(false);
        }
        if (!valid) {
            LangKey.MESSAGE_CANT_PRAY.sendMessage((Player)player, StyleType.COLOR_OFF, new Object[0]);
        }
    }
}

