/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.capability.IServantEntity;
import ovh.corail.tombstone.api.capability.ISpellCaster;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.capability.ProtectedEntityProvider;
import ovh.corail.tombstone.capability.ServantEntityProvider;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.capability.SpellCasterProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TamableType;
import ovh.corail.tombstone.network.CMessagePlayerProtection;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public final class EntityHelper {
    public static int getSpectralBiteLevel(LivingEntity entity) {
        return EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.spectral_bite, (ItemStack)entity.m_6844_(EquipmentSlot.CHEST));
    }

    public static int getCurseOfBonesLevel(LivingEntity entity) {
        return EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.curse_of_bones, (ItemStack)entity.m_6844_(EquipmentSlot.CHEST));
    }

    public static int getSpectralConjurerLevel(LivingEntity entity) {
        return EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.spectral_conjurer, (ItemStack)entity.m_6844_(EquipmentSlot.HEAD));
    }

    public static boolean hasSoulbound(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.soulbound, (ItemStack)stack) > 0 || ModItems.fishing_rod_of_misadventure.isAncient(stack) || stack.m_150930_(Items.f_151058_) && stack.getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).map(c -> c.isEnchanted(stack)).orElse(false) != false || stack.m_150930_((Item)ModItems.grave_key);
    }

    public static boolean isValidPlayer(@Nullable CommandSource sender) {
        return sender instanceof Player && !(sender instanceof FakePlayer);
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof Player && !(entity instanceof FakePlayer);
    }

    public static boolean isValidServerPlayer(@Nullable Entity entity) {
        return EntityHelper.isValidPlayer(entity) && entity.f_19853_ != null && !entity.f_19853_.m_5776_();
    }

    public static boolean isValidServerPlayer(@Nullable Player entity) {
        return EntityHelper.isValidPlayer(entity) && entity.f_19853_ != null && !entity.f_19853_.m_5776_();
    }

    public static boolean isValidPlayer(@Nullable Player player) {
        return player != null && !EntityHelper.isInvalidPlayer(player);
    }

    public static boolean isInvalidPlayer(Player player) {
        return player instanceof FakePlayer;
    }

    public static boolean checkInvalidPlayerForLoot(@Nullable ServerPlayer player) {
        try {
            if (player == null || EntityHelper.isInvalidPlayer((Player)player) || player.f_8906_.m_6198_().m_129523_() == null) {
                return true;
            }
            ServerPlayer existingPlayer = Optional.ofNullable(Helper.getServer()).map(s -> s.m_6846_().m_11259_(player.m_142081_())).orElse(null);
            return existingPlayer == null || !existingPlayer.m_20182_().equals((Object)player.m_20182_());
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static boolean isKilledByOtherPlayer(Player player, DamageSource source) {
        return EntityHelper.isValidPlayer(source.m_7639_()) && !player.equals((Object)source.m_7639_());
    }

    public static Optional<GlobalPos> getHomeLocation(LivingEntity entity) {
        return entity.m_6274_().m_21874_(MemoryModuleType.f_26359_) ? entity.m_6274_().m_21952_(MemoryModuleType.f_26359_) : Optional.empty();
    }

    public static void setPlayerXp(Player player, int amount) {
        if (amount <= 0) {
            return;
        }
        player.f_36078_ = 0;
        player.f_36079_ = 0;
        player.f_36080_ = 0.0f;
        player.f_36080_ += (float)amount / (float)player.m_36323_();
        player.f_36079_ += amount;
        while (player.f_36080_ >= 1.0f) {
            player.f_36080_ = (player.f_36080_ - 1.0f) * (float)player.m_36323_();
            ++player.f_36078_;
            player.f_36080_ /= (float)player.m_36323_();
        }
    }

    public static Pair<Integer, Float> getPlayerXpPair(int experienceTotal) {
        float aExperience;
        if (experienceTotal <= 0) {
            return Pair.of((Object)0, (Object)Float.valueOf(0.0f));
        }
        int aExperienceLevel = 0;
        for (aExperience = (float)experienceTotal / (float)EntityHelper.xpBarCap(aExperienceLevel); aExperience >= 1.0f; aExperience /= (float)EntityHelper.xpBarCap(++aExperienceLevel)) {
            aExperience = (aExperience - 1.0f) * (float)EntityHelper.xpBarCap(aExperienceLevel);
        }
        return Pair.of((Object)aExperienceLevel, (Object)Float.valueOf(aExperience));
    }

    public static int getPlayerTotalXp(Player player) {
        return EntityHelper.getPlayerTotalXp(player.f_36078_, player.f_36080_);
    }

    private static int getPlayerTotalXp(int level, float bar) {
        int experienceTotal = level < 17 ? level * (level + 6) : (level < 32 ? level * (5 * level - 81) / 2 + 360 : level * (9 * level - 325) / 2 + 2220);
        return experienceTotal += Mth.m_14143_((float)((float)EntityHelper.xpBarCap(level) * bar));
    }

    private static int xpBarCap(int level) {
        return level >= 30 ? 112 + (level - 30) * 9 : (level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2);
    }

    public static boolean noGlobalItemCooldown(@Nullable Player player, Item item) {
        return EntityHelper.getGlobalItemCooldownPercent(player, item) <= 0.0f;
    }

    public static boolean noGlobalItemCooldown(@Nullable Player player, ItemStack stack) {
        return EntityHelper.noGlobalItemCooldown(player, stack.m_41720_());
    }

    public static boolean hasGlobalItemCooldown(@Nullable Player player, Item item) {
        return !EntityHelper.noGlobalItemCooldown(player, item);
    }

    public static boolean hasGlobalItemCooldown(@Nullable Player player, ItemStack stack) {
        return EntityHelper.hasGlobalItemCooldown(player, stack.m_41720_());
    }

    public static void setGlobalItemCooldown(Player player, Item item, int ticks) {
        player.m_36335_().m_41524_(item, ticks);
    }

    public static void setGlobalItemCooldown(Player player, ItemStack stack, int ticks) {
        EntityHelper.setGlobalItemCooldown(player, stack.m_41720_(), ticks);
    }

    public static void removeGlobalItemCooldown(@Nullable Player player, Item item) {
        Optional.ofNullable(player).ifPresent(p -> player.m_36335_().m_41524_(item, 0));
    }

    public static float getGlobalItemCooldownPercent(@Nullable Player player, Item item) {
        return Optional.ofNullable(player).map(p -> Float.valueOf(p.m_36335_().m_41521_(item, 0.0f))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static void applyKillResult(DamageSource damageSource, LivingEntity killedEntity) {
        if (EntityHelper.isValidServerPlayer(damageSource.m_7639_())) {
            ServerPlayer player = (ServerPlayer)damageSource.m_7639_();
            assert (player != null);
            if (killedEntity instanceof AbstractVillager) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 0, (Integer)ConfigTombstone.alignment.pointsKillVillager.get()));
                ModTriggers.KILL_ENOUGH_VILLAGER.trigger(player);
            } else if (killedEntity.m_6095_().m_204039_(EntityTypeTags.f_13121_) || killedEntity instanceof Zombie && killedEntity.getPersistentData().m_128471_("siege") || killedEntity instanceof Phantom) {
                player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.reward(player, 0, (Integer)ConfigTombstone.alignment.pointsKillRaider.get()));
                ModTriggers.KILL_ENOUGH_RAIDER.trigger(player);
            }
            if (EntityHelper.isUndead(killedEntity)) {
                ModTriggers.KILL_ENOUGH_UNDEAD.trigger(player);
                if (EntityHelper.isBoss(killedEntity)) {
                    ModTriggers.KILL_UNDEAD_BOSS.trigger(player);
                }
            }
        }
    }

    public static boolean isBadAlignment(Player player) {
        return player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> cap.getAlignmentLevel() < 0).orElse(false);
    }

    public static int getPerkLevelWithBonus(@Nullable Player player, @Nullable Perk perk) {
        return player == null ? 0 : player.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> cap.getPerkLevelWithBonus(player, perk)).orElse(0);
    }

    public static void syncProtectedPlayerCapability(ServerPlayer player) {
        player.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY).ifPresent(cap -> PacketHandler.sendToPlayer(new CMessagePlayerProtection(cap.isActive()), player));
    }

    public static void syncTBCapability(ServerPlayer player, boolean checked) {
        player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> {
            if (checked) {
                int totalPerkPoints = cap.getTotalPerkPoints();
                boolean valid = true;
                Iterator<Map.Entry<Perk, Integer>> it = cap.getPerks().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (!valid || Helper.isDisabledPerk(entry.getKey(), (Player)player)) {
                        it.remove();
                        continue;
                    }
                    int maxPerkLevel = Math.min(totalPerkPoints, entry.getKey().getLevelMax());
                    if (entry.getValue() > maxPerkLevel) {
                        entry.setValue(maxPerkLevel);
                    }
                    for (int i = 1; i <= entry.getValue() && valid; ++i) {
                        int cost = entry.getKey().getCost(i);
                        if (cost <= totalPerkPoints) {
                            totalPerkPoints -= cost;
                            continue;
                        }
                        valid = false;
                        if (i > 1) {
                            entry.setValue(i - 1);
                            continue;
                        }
                        it.remove();
                    }
                }
            }
            cap.syncAll(player);
        });
    }

    public static CompoundTag getPersistentTag(Player player) {
        CompoundTag persistantData = player.getPersistentData();
        if (persistantData.m_128425_("PlayerPersisted", 10)) {
            return persistantData.m_128469_("PlayerPersisted");
        }
        CompoundTag persistantTag = new CompoundTag();
        persistantData.m_128365_("PlayerPersisted", (Tag)persistantTag);
        return persistantTag;
    }

    public static String getRegistryString(@Nullable Entity entity) {
        return entity == null ? "" : EntityHelper.getRegistryString(entity.m_6095_());
    }

    public static String getRegistryString(@Nullable EntityType<?> entityType) {
        return Optional.ofNullable(entityType).map(ForgeRegistryEntry::getRegistryName).map(ResourceLocation::toString).orElse("");
    }

    public static void writePlayerData(MinecraftServer server, Player player) {
        server.m_6846_().f_11204_.m_78433_(player);
    }

    public static void loadPlayerData(MinecraftServer server, Player player) {
        server.m_6846_().f_11204_.m_78435_(player);
    }

    @Nullable
    public static ServerPlayer getOfflinePlayer(MinecraftServer server, UUID id) {
        GameProfile profil = EntityHelper.getGameProfile(server, id);
        if (profil != null) {
            ServerPlayer player = server.m_6846_().m_11300_(profil);
            EntityHelper.loadPlayerData(server, (Player)player);
            return player;
        }
        return null;
    }

    @Nullable
    public static ServerPlayer getOfflinePlayer(MinecraftServer server, String playerName) {
        GameProfile profil = EntityHelper.getGameProfile(server, playerName);
        if (profil != null) {
            ServerPlayer player = server.m_6846_().m_11300_(profil);
            EntityHelper.loadPlayerData(server, (Player)player);
            return player;
        }
        return null;
    }

    @Nullable
    public static GameProfile getGameProfile(MinecraftServer server, UUID id) {
        return server.m_129927_().m_11002_(id).orElse(null);
    }

    @Nullable
    public static GameProfile getGameProfile(MinecraftServer server, String playerName) {
        GameProfileCache.GameProfileInfo entry = (GameProfileCache.GameProfileInfo)server.m_129927_().f_10966_.get(playerName.toLowerCase(Locale.US));
        if (entry != null) {
            return entry.m_11028_();
        }
        return null;
    }

    public static boolean isUndead(LivingEntity entity) {
        return entity.m_6336_() == MobType.f_21641_;
    }

    public static boolean isBoss(LivingEntity entity) {
        return entity.m_21172_(Attributes.f_22276_) >= (double)((Integer)ConfigTombstone.loot.undeadBossLifeForDrop.get()).intValue() && EntityHelper.isEnemy((Entity)entity) && !entity.m_6072_();
    }

    public static boolean targetAnEnemy(LivingEntity entity) {
        Mob mob;
        return entity instanceof Mob && EntityHelper.isEnemy((Entity)(mob = (Mob)entity).m_5448_());
    }

    public static void resetAttackAction(LivingEntity entity) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            mob.f_21346_.m_25386_().forEach(WrappedGoal::m_8041_);
            mob.m_21573_().m_26573_();
            mob.f_21362_ = null;
        }
        entity.m_6703_(null);
        entity.m_6598_(null);
        entity.m_21335_(null);
        if (entity.m_6274_().m_21874_(MemoryModuleType.f_26372_)) {
            entity.m_6274_().m_21886_(MemoryModuleType.f_26372_, Optional.empty());
        }
    }

    public static boolean areOwnerOrServants(LivingEntity entity1, LivingEntity entity2) {
        return EntityHelper.getOwnerOrSelfId(entity1).equals(EntityHelper.getOwnerOrSelfId(entity2));
    }

    private static UUID getOwnerOrSelfId(LivingEntity entity) {
        return Optional.ofNullable(TamableType.getType((Entity)entity)).map(t -> t.getOwnerId((Entity)entity)).orElse(entity.m_142081_());
    }

    public static Optional<LivingEntity> getSpecialTargetForSpell(PathfinderMob caster) {
        return caster.getCapability(SpellCasterProvider.SPELLCASTER_CAPABILITY).filter(ISpellCaster::isCasting).flatMap(ISpellCaster::getSpecialTarget).filter(Entity::m_6084_).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast);
    }

    public static void setSpecialTargetForSpell(PathfinderMob caster, Entity entity) {
        if (entity.m_6084_()) {
            caster.getCapability(SpellCasterProvider.SPELLCASTER_CAPABILITY).ifPresent(cap -> cap.setSpecialTarget(entity));
        }
    }

    public static boolean isEnemy(@Nullable Entity entity) {
        return entity instanceof Enemy && !EntityHelper.isServant(entity) && (!(entity instanceof TamableAnimal) || !((TamableAnimal)entity).m_21824_());
    }

    public static boolean isServant(Entity entity) {
        return entity.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).map(IServantEntity::isActive).orElse(false);
    }

    public static Optional<UUID> getServantOwnerId(Entity entity) {
        return entity.getCapability(ServantEntityProvider.SERVANT_ENTITY_CAPABILITY).filter(IServantEntity::isActive).flatMap(IServantEntity::getOwnerId);
    }

    public static Optional<Player> getServantOwner(Entity entity) {
        return EntityHelper.getServantOwnerId(entity).flatMap(ownerId -> Optional.ofNullable(entity.f_19853_.m_46003_(ownerId)));
    }

    public static boolean noGraveGuardianAround(Level level, BlockPos pos) {
        return level.m_6443_(GraveGuardian.class, new AABB(pos).m_82377_((double)((Integer)ConfigTombstone.decorative_grave.distanceBetweenGraveGuardian.get()).intValue(), 20.0, (double)((Integer)ConfigTombstone.decorative_grave.distanceBetweenGraveGuardian.get()).intValue()), entity -> true).isEmpty();
    }
}

