/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.gui.IOption;
import ovh.corail.tombstone.gui.SliderButton;

@OnlyIn(value=Dist.CLIENT)
public class ProgressOption
implements IOption {
    private final Component caption;
    protected final float steps;
    protected final double minValue;
    protected double maxValue;
    private final Double getter;
    private final Consumer<Double> setter;
    private final Function<ProgressOption, Component> toString;
    private final Function<Minecraft, List<FormattedCharSequence>> tooltipSupplier;

    public ProgressOption(String name, double minValue, double maxValue, float steps, Double getter, Consumer<Double> setter, Function<ProgressOption, Component> toString, Function<Minecraft, List<FormattedCharSequence>> tooltipSupplier) {
        this.caption = new TranslatableComponent(name);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.steps = steps;
        this.getter = getter;
        this.setter = setter;
        this.toString = toString;
        this.tooltipSupplier = tooltipSupplier;
    }

    public ProgressOption(String name, double p_92212_, double p_92213_, float p_92214_, Double p_92215_, Consumer<Double> p_92216_, Function<ProgressOption, Component> p_92217_) {
        this(name, p_92212_, p_92213_, p_92214_, p_92215_, p_92216_, p_92217_, p_168549_ -> ImmutableList.of());
    }

    @Override
    public AbstractWidget createButton(int x, int y, int width) {
        return new SliderButton(x, y, width, 20, this, this.tooltipSupplier.apply(Minecraft.m_91087_()));
    }

    @Override
    public Component getCaption() {
        return this.caption;
    }

    public double toPct(double value) {
        return Mth.m_14008_((double)((this.clamp(value) - this.minValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
    }

    public double toValue(double value) {
        return this.clamp(Mth.m_14139_((double)Mth.m_14008_((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue));
    }

    private double clamp(double value) {
        if (this.steps > 0.0f) {
            value = this.steps * (float)Math.round(value / (double)this.steps);
        }
        return Mth.m_14008_((double)value, (double)this.minValue, (double)this.maxValue);
    }

    public void set(double value) {
        this.setter.accept(value);
    }

    public double get() {
        return this.getter;
    }

    public Component getMessage() {
        return this.toString.apply(this);
    }
}

