/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.PlayMessages;
import ovh.corail.tombstone.entity.ai.OwnerHurtByTargetGoal;
import ovh.corail.tombstone.entity.ai.OwnerHurtTargetGoal;
import ovh.corail.tombstone.entity.ai.StayNearHome;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEntities;

public final class SpectralWolf
extends Animal {
    @Nullable
    private GlobalPos homePos = null;
    @Nullable
    private UUID ownerId = null;
    private static final EntityDataAccessor<Integer> DATA_REMAINING_TIME = SynchedEntityData.m_135353_(SpectralWolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SpectralWolf(EntityType<? extends SpectralWolf> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.0f;
        this.m_21553_(false);
    }

    public SpectralWolf(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this(ModEntities.spectral_wolf, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(4, new StayNearHome<SpectralWolf>(this, SpectralWolf::getHomePos, SpectralWolf::resetHomePos, 0.8));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        if (this.ownerId != null) {
            this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((Mob)this){

                @Override
                protected Optional<Player> getOwner() {
                    return SpectralWolf.this.getOwner();
                }
            });
            this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((Mob)this){

                @Override
                protected Optional<Player> getOwner() {
                    return SpectralWolf.this.getOwner();
                }
            });
        } else {
            this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}));
        }
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, true, EntityHelper::isEnemy));
    }

    public void m_8107_() {
        int timeRemaining = this.getLifetime() - 1;
        if (timeRemaining <= 0) {
            this.m_142467_(Entity.RemovalReason.DISCARDED);
        } else {
            this.setLifetime(timeRemaining);
        }
        super.m_8107_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_TIME, (Object)12000);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("remaining_time", this.getLifetime());
        if (this.homePos != null) {
            NBTStackHelper.setLocation(compoundTag, "home_position", new Location(this.homePos));
        }
        NBTStackHelper.setUUID(compoundTag, "owner_id", this.ownerId);
    }

    public void m_7378_(CompoundTag compoundTag) {
        Location loc;
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("remaining_time", 99)) {
            this.setLifetime(compoundTag.m_128451_("remaining_time"));
        }
        if (!(loc = NBTStackHelper.getLocation(compoundTag, "home_position")).isOrigin()) {
            this.homePos = loc.asGlobalPos();
        }
        this.ownerId = NBTStackHelper.getUUID(compoundTag, "owner_id").orElse(null);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_() && this.m_6084_() && TimeHelper.atInterval(this.f_19853_, 100)) {
            this.m_5634_(1.0f);
        }
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos).m_204336_(BlockTags.f_13080_) ? 5.0f : 0.0f;
    }

    public GlobalPos getHomePos() {
        if (this.homePos == null) {
            this.resetHomePos();
        }
        return this.homePos;
    }

    public void resetHomePos() {
        this.homePos = GlobalPos.m_122643_((ResourceKey)this.f_19853_.m_46472_(), (BlockPos)this.m_142538_());
    }

    public void setLifetime(int lifetime) {
        this.f_19804_.m_135381_(DATA_REMAINING_TIME, (Object)lifetime);
    }

    public int getLifetime() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_TIME);
    }

    public void setOwner(@Nullable Player owner) {
        this.ownerId = Optional.ofNullable(owner).map(Player::m_36316_).map(GameProfile::getId).orElse(null);
    }

    public Optional<Player> getOwner() {
        return Optional.ofNullable(this.ownerId).map(ownerId -> this.f_19853_.m_46003_(ownerId));
    }

    public void m_6043_() {
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected int m_7302_(int air) {
        return air;
    }

    protected boolean m_6125_() {
        return false;
    }

    protected void m_7472_(DamageSource damageSource, int p_34175_, boolean p_34176_) {
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return super.m_7301_(effectInstance) && !EffectHelper.isHarmful(effectInstance.m_19544_());
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_20177_(Player player) {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.8f;
    }

    public boolean m_7327_(Entity target) {
        boolean flag = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, target);
        }
        return flag;
    }

    public float getTailAngle() {
        return 1.5393804f;
    }

    public boolean m_7848_(Animal animal) {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12619_;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12621_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public static AttributeSupplier buildAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 2.0).m_22265_();
    }
}

