/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.ArmorEnchantment;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public class EnchantmentSpectralConjurer
extends ArmorEnchantment {
    private static final String SPECTRAL_CONJURER_LAST_PROC_NBT_LONG = "spectral_conjurer_last_proc";

    public EnchantmentSpectralConjurer() {
        super("spectral_conjurer", Enchantment.Rarity.RARE, EnchantmentCategory.ARMOR_HEAD, EquipmentSlot.HEAD);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentSpectralConjurer.get();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.spectralConjurerEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    protected void onWearerHit(LivingEntity wearer, Entity attacker, int amplifier) {
        amplifier = EntityHelper.getSpectralConjurerLevel(wearer);
        if (amplifier > 0) {
            boolean valid;
            double scale = Helper.getScale(this, amplifier);
            int delay = TimeHelper.tickFromSecond((Integer)ConfigTombstone.enchantments.maxCooldownSpectralConjurer.get() - (int)(scale * (double)((Integer)ConfigTombstone.enchantments.maxCooldownSpectralConjurer.get() - (Integer)ConfigTombstone.enchantments.minCooldownSpectralConjurer.get())));
            CompoundTag persistantData = wearer.getPersistentData();
            boolean bl = valid = !persistantData.m_128425_(SPECTRAL_CONJURER_LAST_PROC_NBT_LONG, 4);
            if (!valid) {
                long timeLeft = persistantData.m_128454_(SPECTRAL_CONJURER_LAST_PROC_NBT_LONG) - (long)wearer.f_19797_;
                if (timeLeft <= 0L) {
                    persistantData.m_128473_(SPECTRAL_CONJURER_LAST_PROC_NBT_LONG);
                    valid = true;
                } else if (timeLeft > (long)delay) {
                    persistantData.m_128356_(SPECTRAL_CONJURER_LAST_PROC_NBT_LONG, (long)(wearer.f_19797_ + delay));
                }
            }
            if (valid && this.testProc(amplifier)) {
                Helper.spawnSpectralWolf(wearer.f_19853_, wearer.m_142538_(), TimeHelper.tickFromSecond((int)((double)((Integer)ConfigTombstone.enchantments.maxDurationSpectralConjurer.get()).intValue() * scale)), EntityHelper.isValidPlayer((Entity)wearer) ? (Player)wearer : null);
                wearer.getPersistentData().m_128356_(SPECTRAL_CONJURER_LAST_PROC_NBT_LONG, (long)(wearer.f_19797_ + delay));
            }
        }
    }
}

