/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.stream.Collectors;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.enchantment.WeaponEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModTriggers;

public final class EnchantmentMagicSiphon
extends WeaponEnchantment {
    public EnchantmentMagicSiphon() {
        super("magic_siphon", Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)SharedConfigTombstone.enchantments.enableEnchantmentMagicSiphon.get();
    }

    protected boolean m_5975_(Enchantment ench) {
        return super.m_5975_(ench) && ((Boolean)SharedConfigTombstone.enchantments.allowPlagueBringerCombiningMagicSiphon.get() != false || ench != ModEnchantments.plague_bringer);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (Boolean)SharedConfigTombstone.enchantments.magicSiphonEnchantingTable.get() != false && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    public void onProc(LivingEntity attacker, LivingEntity target, int amplifier) {
        Helper.getRandomInList(target.m_21220_().stream().filter(EffectHelper::isAllowedEffect).collect(Collectors.toList())).ifPresent(effectInstance -> {
            int stolenDuration = Math.min(TimeHelper.tickFromMinute((Integer)ConfigTombstone.enchantments.maxDurationMagicSiphon.get()), effectInstance.m_19557_() / (ConfigTombstone.enchantments.magicSiphonOnPlayerRule.get() == ConfigTombstone.Enchantments.MagicSiphonOnPlayerRule.NERFED && EntityHelper.isValidPlayer((Entity)target) ? 10 : 1));
            if (stolenDuration < 1) {
                return;
            }
            MobEffectInstance effectCopy = new MobEffectInstance(effectInstance);
            effectCopy.f_19503_ = stolenDuration;
            attacker.m_7292_(effectCopy);
            EffectHelper.clearEffect(target, effectInstance.m_19544_());
            if (stolenDuration < effectInstance.m_19557_()) {
                effectInstance.f_19503_ -= stolenDuration;
                target.m_7292_(effectInstance);
            }
            if (target.m_21223_() > target.m_21233_()) {
                target.m_21153_(target.m_21233_());
            }
            if (EntityHelper.isValidServerPlayer((Entity)attacker)) {
                ModTriggers.STEAL_EFFECT.trigger((ServerPlayer)attacker);
            }
        });
    }

    @Override
    protected boolean canAffectTarget(LivingEntity target) {
        return ConfigTombstone.enchantments.magicSiphonOnPlayerRule.get() != ConfigTombstone.Enchantments.MagicSiphonOnPlayerRule.DISALLOW || !EntityHelper.isValidPlayer((Entity)target);
    }
}

