/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.ClawInventory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.compatibility.IEquipableCompat;
import ovh.corail.tombstone.helper.Helper;

public class CompatibilityDragonSurvival
implements IEquipableCompat {
    public static final CompatibilityDragonSurvival instance = new CompatibilityDragonSurvival();
    public static final Capability<DragonStateHandler> DRAGON_STATE = CapabilityManager.get((CapabilityToken)new CapabilityToken<DragonStateHandler>(){});
    private boolean isEnabled = true;
    private final Method methodGetClawsInventory = Optional.ofNullable(Helper.getClass("by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler")).map(c -> Optional.ofNullable(Helper.getMethod(c, "getClawInventory", new Class[0])).orElse(Helper.getMethod(c, "getClawToolData", new Class[0]))).orElse(null);

    private CompatibilityDragonSurvival() {
    }

    @Override
    public boolean autoEquip(ItemStack stack, Player player) {
        if (DRAGON_STATE == null || !this.isEnabled) {
            return false;
        }
        int slotId = this.getSlot(stack);
        return slotId >= 0 && player.getCapability(DRAGON_STATE).filter(DragonStateHandler::isDragon).map(cap -> {
            SimpleContainer invent;
            try {
                invent = Optional.ofNullable((ClawInventory)this.methodGetClawsInventory.invoke(cap, new Object[0])).map(ClawInventory::getClawsInventory).orElse(null);
            }
            catch (IllegalAccessException | InvocationTargetException ignored) {
                this.isEnabled = false;
                ModTombstone.LOGGER.warn("Disabling auto-equip compatibility with Dragon Survival. Please contact Corail31.");
                return false;
            }
            if (invent != null && invent.m_8020_(slotId).m_41619_()) {
                invent.m_6836_(slotId, stack.m_41777_());
                return true;
            }
            return false;
        }).orElse(false) != false;
    }

    private int getSlot(ItemStack stack) {
        if (stack.canPerformAction(ToolActions.PICKAXE_DIG)) {
            return 1;
        }
        if (stack.canPerformAction(ToolActions.AXE_DIG)) {
            return 2;
        }
        if (stack.canPerformAction(ToolActions.SHOVEL_DIG)) {
            return 3;
        }
        if (stack.canPerformAction(ToolActions.SWORD_SWEEP) || stack.m_41720_() instanceof SwordItem) {
            return 0;
        }
        return -1;
    }
}

