/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.block.util.ICustomDataHolder;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SkeletonHorse.class})
public abstract class SkellyHorseMixin
extends AbstractHorse
implements ICustomDataHolder {
    @Unique
    private int fleshCount = 0;
    @Unique
    private int conversionTime = -1;

    @Override
    public boolean getVariable() {
        return this.isConverting();
    }

    @Override
    public void setVariable(boolean val) {
    }

    protected SkellyHorseMixin(EntityType<? extends AbstractHorse> p_i48563_1_, Level p_i48563_2_) {
        super(p_i48563_1_, p_i48563_2_);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag compoundNBT, CallbackInfo ci) {
        compoundNBT.m_128405_("FleshCount", this.fleshCount);
        compoundNBT.m_128405_("ConversionTime", this.conversionTime);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag compoundNBT, CallbackInfo ci) {
        this.fleshCount = compoundNBT.m_128451_("FleshCount");
        this.conversionTime = compoundNBT.m_128451_("ConversionTime");
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack;
        if (ServerConfigs.cached.ZOMBIE_HORSE && this.m_30614_() && !this.m_6162_() && (stack = player.m_21120_(hand)).m_41720_() == Items.f_42583_ && this.fleshCount < ServerConfigs.cached.ZOMBIE_HORSE_COST) {
            this.feedRottenFlesh(player, hand, stack);
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_));
        }
    }

    @Nullable
    protected SoundEvent m_7872_() {
        return SoundEvents.f_11976_;
    }

    public void feedRottenFlesh(Player player, InteractionHand hand, ItemStack stack) {
        float heal = 0.5f;
        if (this.m_21223_() < this.m_21233_()) {
            this.m_5634_(heal);
        }
        this.m_30661_(true);
        ++this.fleshCount;
        if (this.fleshCount >= ServerConfigs.cached.ZOMBIE_HORSE_COST) {
            this.conversionTime = 200;
            this.f_19853_.m_7605_((Entity)this, (byte)16);
        }
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    private boolean isConverting() {
        return this.conversionTime > 0;
    }

    private void doZombieConversion() {
        float yBodyRot = this.f_20883_;
        float yHeadRot = this.f_20885_;
        float yBodyRotO = this.f_20884_;
        float yHeadRotO = this.f_20886_;
        AbstractHorse newHorse = (AbstractHorse)this.m_21406_(EntityType.f_20502_, true);
        if (newHorse != null) {
            newHorse.f_20883_ = yBodyRot;
            newHorse.f_20885_ = yHeadRot;
            newHorse.f_20886_ = yHeadRotO;
            newHorse.m_30586_(this.m_30615_());
            newHorse.m_30651_(this.m_30614_());
            newHorse.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
            if (this.m_6254_()) {
                newHorse.m_5853_(null);
            }
            for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                ItemStack itemstack = this.m_6844_(equipmentslottype);
                if (itemstack.m_41619_()) continue;
                if (EnchantmentHelper.m_44920_((ItemStack)itemstack)) {
                    newHorse.m_141942_(equipmentslottype.m_20749_() + 300).m_142104_(itemstack);
                    continue;
                }
                double d0 = this.m_21519_(equipmentslottype);
                if (!(d0 > 1.0)) continue;
                this.m_19983_(itemstack);
            }
            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)newHorse);
        }
        if (!this.m_20067_()) {
            this.f_19853_.m_5898_(null, 1027, this.m_142538_(), 0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte p_70103_1_) {
        if (p_70103_1_ == 16) {
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_12644_, this.m_5720_(), 1.0f + this.f_19796_.nextFloat(), this.f_19796_.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.m_7822_(p_70103_1_);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.m_21525_() && this.isConverting()) {
            --this.conversionTime;
            if (this.conversionTime == 0) {
                this.doZombieConversion();
            }
        }
    }
}

