/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundCycleQuiverPacket {
    private final int amount;
    private final boolean mainHand;
    private final boolean setSlot;

    public ServerBoundCycleQuiverPacket(FriendlyByteBuf buf) {
        this.amount = buf.readInt();
        this.mainHand = buf.readBoolean();
        this.setSlot = buf.readBoolean();
    }

    public ServerBoundCycleQuiverPacket(int amount, boolean mainHand, boolean setSlot) {
        this.amount = amount;
        this.mainHand = mainHand;
        this.setSlot = setSlot;
    }

    public ServerBoundCycleQuiverPacket(int amount, boolean mainHand) {
        this(amount, mainHand, false);
    }

    public static void buffer(ServerBoundCycleQuiverPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.amount);
        buf.writeBoolean(message.mainHand);
        buf.writeBoolean(message.setSlot);
    }

    public static void handler(ServerBoundCycleQuiverPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = Objects.requireNonNull(((NetworkEvent.Context)ctx.get()).getSender());
            if (player.m_7655_() == InteractionHand.MAIN_HAND != message.mainHand) {
                boolean bl = true;
            } else {
                ItemStack stack = player.m_21211_();
                if (stack.m_41720_() != ModRegistry.QUIVER_ITEM.get()) {
                    boolean bl = true;
                } else {
                    QuiverItem.IQuiverData data = QuiverItem.getQuiverData(stack);
                    if (message.setSlot) {
                        data.setSelectedSlot(message.amount);
                    } else {
                        data.cycle(message.amount);
                    }
                }
            }
        });
    }
}

