/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.common.entities.dispenser_minecart.MovingBlockSource;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.network.NetworkHooks;

public class PearlMarker
extends Entity {
    private Pair<ThrownEnderpearl, HitResult> event = null;
    private final List<ThrownEnderpearl> pearls = new ArrayList<ThrownEnderpearl>();
    private static final EntityDataAccessor<BlockPos> TELEPORT_POS = SynchedEntityData.m_135353_(PearlMarker.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public PearlMarker(Level worldIn) {
        super((EntityType)ModRegistry.PEARL_MARKER.get(), worldIn);
        this.m_20242_(true);
        this.m_20331_(true);
    }

    public PearlMarker(EntityType<PearlMarker> type, Level level) {
        super(type, level);
        this.m_6842_(true);
        this.m_20242_(true);
        this.m_20331_(true);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TELEPORT_POS, (Object)this.m_142538_());
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    public void m_6074_() {
        this.m_146870_();
    }

    public void m_8119_() {
        BlockPos pos;
        BlockState state;
        super.m_6075_();
        boolean dead = this.pearls.isEmpty();
        if (!dead && !((state = this.f_19853_.m_8055_(pos = this.m_142538_())).m_60734_() instanceof DispenserBlock)) {
            PistonMovingBlockEntity p;
            PistonMovingBlockEntity piston = null;
            boolean didOffset = false;
            BlockEntity tile = this.f_19853_.m_7702_(pos);
            if (tile instanceof PistonMovingBlockEntity && (p = (PistonMovingBlockEntity)tile).m_60400_().m_60734_() instanceof DispenserBlock) {
                piston = p;
            } else {
                for (Direction d : Direction.values()) {
                    PistonMovingBlockEntity p2;
                    BlockPos offPos = pos.m_142300_(d);
                    tile = this.f_19853_.m_7702_(offPos);
                    if (!(tile instanceof PistonMovingBlockEntity) || !((p2 = (PistonMovingBlockEntity)tile).m_60400_().m_60734_() instanceof DispenserBlock)) continue;
                    piston = p2;
                    break;
                }
            }
            if (piston != null) {
                Direction dir = piston.m_60399_();
                this.m_6478_(MoverType.PISTON, new Vec3((double)dir.m_122429_() * 0.33, (double)dir.m_122430_() * 0.33, (double)dir.m_122431_() * 0.33));
                didOffset = true;
            }
            boolean bl = dead = !didOffset;
        }
        if (dead && !this.f_19853_.f_46443_) {
            this.m_146870_();
        }
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void removePearl(ThrownEnderpearl pearl) {
        this.pearls.remove(pearl);
    }

    public void addPearl(ThrownEnderpearl pearl) {
        this.pearls.add(pearl);
    }

    public void m_6021_(double pX, double pY, double pZ) {
        if (this.event != null) {
            HitResult trace = (HitResult)this.event.getSecond();
            ThrownEnderpearl pearl = (ThrownEnderpearl)this.event.getFirst();
            if (trace instanceof BlockHitResult) {
                BlockHitResult hitResult = (BlockHitResult)trace;
                BlockPos fromPos = this.m_142538_();
                BlockState state = this.f_19853_.m_8055_(fromPos);
                BlockEntity blockEntity = this.f_19853_.m_7702_(fromPos);
                if (state.m_60734_() instanceof DispenserBlock && blockEntity instanceof DispenserBlockEntity) {
                    BlockPos toPos = hitResult.m_82425_().m_142300_(hitResult.m_82434_());
                    if (this.f_19853_.m_8055_(toPos).m_60767_().m_76336_()) {
                        CompoundTag nbt = blockEntity.m_187482_();
                        blockEntity.m_7651_();
                        if (this.f_19853_.m_46597_(fromPos, Blocks.f_50016_.m_49966_()) && this.f_19853_.m_46597_(toPos, (BlockState)state.m_61124_((Property)DispenserBlock.f_52659_, (Comparable)hitResult.m_82434_()))) {
                            BlockEntity dstEntity = this.f_19853_.m_7702_(toPos);
                            if (dstEntity instanceof DispenserBlockEntity) {
                                dstEntity.m_142466_(nbt);
                            }
                            SoundType type = state.m_60827_();
                            this.f_19853_.m_5594_(null, toPos, type.m_56777_(), SoundSource.BLOCKS, (type.m_56773_() + 1.0f) / 2.0f, type.m_56774_() * 0.8f);
                        }
                    }
                    this.setTeleportPos(toPos);
                    this.f_19853_.m_7605_((Entity)this, (byte)92);
                    super.m_6021_((double)toPos.m_123341_() + 0.5, (double)toPos.m_123342_() + 0.5 - (double)(this.m_20206_() / 2.0f), (double)toPos.m_123343_() + 0.5);
                }
            }
            this.removePearl(pearl);
            pearl.m_146870_();
            this.event = null;
        } else {
            super.m_6021_(pX, pY, pZ);
        }
    }

    public BlockPos getTeleportPos() {
        return (BlockPos)this.f_19804_.m_135370_(TELEPORT_POS);
    }

    public void setTeleportPos(BlockPos pos) {
        this.f_19804_.m_135381_(TELEPORT_POS, (Object)pos);
    }

    public void m_7822_(byte pId) {
        if (pId == 92 && this.f_19853_.f_46443_) {
            Random random = this.f_19853_.f_46441_;
            BlockPos end = this.getTeleportPos();
            BlockPos start = this.m_142538_();
            for (int j = 0; j < 64; ++j) {
                double d0 = random.nextDouble();
                float f = (random.nextFloat() - 0.5f) * 0.2f;
                float f1 = (random.nextFloat() - 0.5f) * 0.2f;
                float f2 = (random.nextFloat() - 0.5f) * 0.2f;
                double d1 = Mth.m_14139_((double)d0, (double)end.m_123341_(), (double)start.m_123341_()) + (random.nextDouble() - 0.5) + 0.5;
                double d2 = Mth.m_14139_((double)d0, (double)end.m_123342_(), (double)start.m_123342_()) + random.nextDouble() - 0.5;
                double d3 = Mth.m_14139_((double)d0, (double)end.m_123343_(), (double)start.m_123343_()) + (random.nextDouble() - 0.5) + 0.5;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d1, d2, d3, (double)f, (double)f1, (double)f2);
            }
        }
        super.m_7822_(pId);
    }

    public void m_6453_(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
        super.m_6453_(pX, pY, pZ, pYaw, pPitch, pPosRotationIncrements, pTeleport);
        this.m_6034_(pX, pY, pZ);
    }

    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Projectile throwable = event.getProjectile();
        HitResult trace = event.getRayTraceResult();
        Level level = throwable.f_19853_;
        if (!level.f_46443_ && throwable instanceof ThrownEnderpearl) {
            ThrownEnderpearl pearl = (ThrownEnderpearl)throwable;
            Entity entity2 = throwable.m_37282_();
            if (entity2 instanceof PearlMarker) {
                PearlMarker markerEntity = (PearlMarker)entity2;
                if (throwable.m_20137_("dispensed")) {
                    markerEntity.event = Pair.of((Object)pearl, (Object)trace);
                }
            }
        }
    }

    public static ThrownEnderpearl getPearlToDispense(BlockSource source, Level level, BlockPos pos) {
        ThrownEnderpearl pearl = new ThrownEnderpearl(EntityType.f_20484_, level);
        if (source instanceof MovingBlockSource) {
            MovingBlockSource movingBlockSource = (MovingBlockSource)source;
            pearl.m_5602_(movingBlockSource.getMinecartEntity());
        } else {
            PearlMarker marker;
            Optional entity2 = level.m_6443_(PearlMarker.class, new AABB(pos), e -> e.m_142538_().equals((Object)pos)).stream().findAny();
            if (entity2.isEmpty()) {
                marker = new PearlMarker(level);
                marker.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5 - (double)(marker.m_20206_() / 2.0f), (double)pos.m_123343_() + 0.5);
                level.m_7967_((Entity)marker);
            } else {
                marker = (PearlMarker)((Object)entity2.get());
            }
            marker.addPearl(pearl);
            pearl.m_5602_((Entity)marker);
        }
        Position position = DispenserBlock.m_52720_((BlockSource)source);
        pearl.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
        pearl.m_20049_("dispensed");
        return pearl;
    }
}

