/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.capabilities.mobholder;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.MobBucketItem;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BucketHelper {
    private static final BiMap<Item, String> BUCKET_TO_MOB_MAP = HashBiMap.create();
    private static Method FISH_TYPE = null;

    @Nullable
    public static EntityType<?> getEntityType(Item bucket) {
        if (BUCKET_TO_MOB_MAP.containsKey((Object)bucket)) {
            EntityType en;
            String mobId = (String)BUCKET_TO_MOB_MAP.get((Object)bucket);
            ResourceLocation res = new ResourceLocation(mobId);
            if (ForgeRegistries.ENTITIES.containsKey(res) && (en = (EntityType)ForgeRegistries.ENTITIES.getValue(res)) != null) {
                return (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(mobId));
            }
        } else if (bucket instanceof MobBucketItem) {
            MobBucketItem bucketItem = (MobBucketItem)bucket;
            try {
                EntityType en;
                if (FISH_TYPE == null) {
                    FISH_TYPE = ObfuscationReflectionHelper.findMethod(MobBucketItem.class, (String)"getFishType", (Class[])new Class[0]);
                }
                if ((en = (EntityType)FISH_TYPE.invoke((Object)bucketItem, new Object[0])) != null) {
                    BUCKET_TO_MOB_MAP.putIfAbsent((Object)bucket, (Object)en.getRegistryName().toString());
                    return en;
                }
            }
            catch (Exception en) {}
        } else {
            EntityType en;
            ResourceLocation res;
            String mobId = null;
            String itemName = bucket.getRegistryName().toString();
            if (itemName.contains("_bucket")) {
                mobId = itemName.replace("_bucket", "");
            } else if (itemName.contains("bucket_of_")) {
                mobId = itemName.replace("_bucket", "");
            } else if (itemName.contains("bucket_")) {
                mobId = itemName.replace("bucket_", "");
            }
            if (mobId != null && ForgeRegistries.ENTITIES.containsKey(res = new ResourceLocation(mobId)) && (en = (EntityType)ForgeRegistries.ENTITIES.getValue(res)) != null) {
                BUCKET_TO_MOB_MAP.putIfAbsent((Object)bucket, (Object)en.getRegistryName().toString());
                return en;
            }
        }
        return null;
    }

    public static void tryAddingFromEntityId(String id) {
    }

    public static Collection<Item> getValidBuckets() {
        return BUCKET_TO_MOB_MAP.keySet();
    }

    public static boolean isFishBucket(Item item2) {
        return BucketHelper.getEntityType(item2) != null;
    }

    public static boolean isBucketableEntity(String mobId) {
        return BUCKET_TO_MOB_MAP.containsValue((Object)mobId);
    }

    public static void associateMobToBucketIfAbsent(EntityType<?> entity2, Item item2) {
        if (!BUCKET_TO_MOB_MAP.containsKey((Object)item2)) {
            String name = entity2.getRegistryName().toString();
            if (!BUCKET_TO_MOB_MAP.inverse().containsKey((Object)name)) {
                BUCKET_TO_MOB_MAP.putIfAbsent((Object)item2, (Object)name);
            }
        }
    }
}

