/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.common.block.blocks.BubbleBlock;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BubbleBlockTile
extends BlockEntity {
    private int age = 0;
    public float prevScale = 0.1f;
    public float scale = 0.1f;

    public BubbleBlockTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.BUBBLE_BLOCK_TILE.get(), pos, state);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, BubbleBlockTile tile) {
        if (pLevel.f_46443_) {
            tile.prevScale = tile.scale;
            tile.scale = Math.min(1.0f, tile.scale + 0.001f + (1.0f - tile.scale) * ClientConfigs.cached.BUBBLE_BLOCK_GROW_SPEED);
        } else {
            int lifetime = ServerConfigs.cached.BUBBLE_LIFETIME;
            if (lifetime == 10000) {
                return;
            }
            ++tile.age;
            if ((tile.age + 5) % 20 == 0) {
                for (Direction d : Direction.values()) {
                    if (!tile.f_58857_.m_8055_(tile.m_58899_().m_142300_(d)).m_60713_((Block)ModRegistry.SOAP_BLOCK.get())) continue;
                    tile.age = 0;
                    return;
                }
            }
            if (tile.age > lifetime && pLevel.f_46441_.nextInt(500) == 0) {
                ((BubbleBlock)((Object)ModRegistry.BUBBLE_BLOCK.get())).breakBubble((ServerLevel)pLevel, pPos, pState);
            }
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("age", this.age);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.age = pTag.m_128451_("age");
    }
}

