/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Random;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LightUpWaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.RopeBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CandelabraBlock
extends LightUpWaterBlock {
    protected static final VoxelShape SHAPE_FLOOR = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_WALL_NORTH = Block.m_49796_((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SHAPE_WALL_SOUTH = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)14.0, (double)5.0);
    protected static final VoxelShape SHAPE_WALL_WEST = Block.m_49796_((double)11.0, (double)0.0, (double)5.0, (double)16.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_WALL_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
    protected static final VoxelShape SHAPE_CEILING = Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.f_61376_;

    public CandelabraBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_(FACE, (Comparable)AttachFace.FLOOR)).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = direction.m_122434_() == Direction.Axis.Y ? (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).m_61124_((Property)FACING, (Comparable)context.m_8125_()) : (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)AttachFace.WALL)).m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!flag));
        }
        return null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACE, FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((AttachFace)state.m_61143_(FACE)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> SHAPE_FLOOR;
            case AttachFace.WALL -> {
                switch ((Direction)state.m_61143_((Property)FACING)) {
                    default: {
                        yield SHAPE_WALL_NORTH;
                    }
                    case SOUTH: {
                        yield SHAPE_WALL_SOUTH;
                    }
                    case WEST: {
                        yield SHAPE_WALL_WEST;
                    }
                    case EAST: 
                }
                yield SHAPE_WALL_EAST;
            }
            case AttachFace.CEILING -> SHAPE_CEILING;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.m_61143_(FACE) == AttachFace.FLOOR) {
            return CandelabraBlock.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
        }
        if (state.m_61143_(FACE) == AttachFace.CEILING) {
            return RopeBlock.isSupportingCeiling(pos.m_7494_(), worldIn);
        }
        return CandelabraBlock.isSideSolidForDirection(worldIn, pos, ((Direction)state.m_61143_((Property)FACING)).m_122424_());
    }

    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        double zr;
        double xr;
        double zl;
        double yl;
        double xl;
        double zm;
        double ym;
        double xm;
        if (!((Boolean)stateIn.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        Direction dir1 = (Direction)stateIn.m_61143_((Property)FACING);
        Direction dir = dir1.m_122427_();
        double xOff = (double)dir.m_122429_() * 0.3125;
        double zOff = (double)dir.m_122431_() * 0.3125;
        switch ((AttachFace)stateIn.m_61143_(FACE)) {
            default: {
                xm = (double)pos.m_123341_() + 0.5;
                ym = (double)pos.m_123342_() + 1.0;
                zm = (double)pos.m_123343_() + 0.5;
                xl = (double)pos.m_123341_() + 0.5 - xOff;
                yl = (double)pos.m_123342_() + 0.9375;
                zl = (double)pos.m_123343_() + 0.5 - zOff;
                xr = (double)pos.m_123341_() + 0.5 + xOff;
                zr = (double)pos.m_123343_() + 0.5 + zOff;
                break;
            }
            case WALL: {
                double xo1 = (double)(-dir1.m_122429_()) * 0.3125;
                double zo2 = (double)(-dir1.m_122431_()) * 0.3125;
                xm = (double)pos.m_123341_() + 0.5 + xo1;
                ym = pos.m_123342_() + 1;
                zm = (double)pos.m_123343_() + 0.5 + zo2;
                xl = (double)pos.m_123341_() + 0.5 + xo1 - xOff;
                yl = (double)pos.m_123342_() + 0.9375;
                zl = (double)pos.m_123343_() + 0.5 + zo2 - zOff;
                xr = (double)pos.m_123341_() + 0.5 + xo1 + xOff;
                zr = (double)pos.m_123343_() + 0.5 + zo2 + zOff;
                break;
            }
            case CEILING: {
                xm = (double)pos.m_123341_() + 0.5 + zOff;
                zm = (double)pos.m_123343_() + 0.5 - xOff;
                ym = (double)pos.m_123342_() + 0.875;
                xl = (double)pos.m_123341_() + 0.5 + xOff;
                zl = (double)pos.m_123343_() + 0.5 + zOff;
                xr = (double)pos.m_123341_() + 0.5 - zOff;
                zr = (double)pos.m_123343_() + 0.5 + xOff;
                yl = (double)pos.m_123342_() + 0.8125;
                double xs = (double)pos.m_123341_() + 0.5 - xOff;
                double zs = (double)pos.m_123343_() + 0.5 - zOff;
                double ys = (double)pos.m_123342_() + 0.75;
                worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, xs, ys, zs, 0.0, 0.0, 0.0);
            }
        }
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, xm, ym, zm, 0.0, 0.0, 0.0);
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, xl, yl, zl, 0.0, 0.0, 0.0);
        worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123744_, xr, yl, zr, 0.0, 0.0, 0.0);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return CandelabraBlock.getFacing(stateIn).m_122424_() == facing && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected static Direction getFacing(BlockState state) {
        return switch ((AttachFace)state.m_61143_(FACE)) {
            case AttachFace.CEILING -> Direction.DOWN;
            case AttachFace.FLOOR -> Direction.UP;
            default -> (Direction)state.m_61143_((Property)FACING);
        };
    }

    public static boolean isSideSolidForDirection(LevelReader reader, BlockPos pos, Direction direction) {
        BlockPos blockpos = pos.m_142300_(direction);
        return reader.m_8055_(blockpos).m_60783_((BlockGetter)reader, blockpos, direction.m_122424_());
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }
}

