/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundCycleQuiverPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;

public class QuiverArrowSelectGui
extends Gui
implements IIngameOverlay {
    static final ResourceLocation TEXTURE = Supplementaries.res("textures/gui/quiver_select.png");
    private static boolean active;
    private static double lastCumulativeMouseDx;
    protected final ItemRenderer f_92987_;
    protected final Minecraft f_92986_;

    public static boolean isActive() {
        return active;
    }

    public QuiverArrowSelectGui(Minecraft minecraft) {
        super(minecraft);
        this.f_92987_ = minecraft.m_91291_();
        this.f_92986_ = minecraft;
    }

    public static void setActive(boolean on) {
        if (on != active) {
            lastCumulativeMouseDx = 0.0;
        }
        active = on;
    }

    public static void ohMouseMoved(double deltaX) {
        LocalPlayer player;
        int oldI;
        int slotsMoved;
        double scale = Minecraft.m_91087_().f_91066_.f_92053_ * 0.02;
        if ((slotsMoved = (int)((lastCumulativeMouseDx += deltaX) * scale) - (oldI = (int)(lastCumulativeMouseDx * scale))) != 0 && (player = Minecraft.m_91087_().f_91074_) != null) {
            NetworkHandler.INSTANCE.sendToServer((Object)new ServerBoundCycleQuiverPacket(slotsMoved, player.m_7655_() == InteractionHand.MAIN_HAND));
        }
    }

    public static boolean onMouseScrolled(double scrollDelta) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        NetworkHandler.INSTANCE.sendToServer((Object)new ServerBoundCycleQuiverPacket(scrollDelta > 0.0 ? 1 : -1, player.m_7655_() == InteractionHand.MAIN_HAND));
        return true;
    }

    public static boolean onKeyPressed(int key, int action, int modifiers) {
        if (action == 1) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            switch (key) {
                case 263: {
                    NetworkHandler.INSTANCE.sendToServer((Object)new ServerBoundCycleQuiverPacket(-1, player.m_7655_() == InteractionHand.MAIN_HAND));
                    return true;
                }
                case 262: {
                    NetworkHandler.INSTANCE.sendToServer((Object)new ServerBoundCycleQuiverPacket(1, player.m_7655_() == InteractionHand.MAIN_HAND));
                    return true;
                }
            }
            int number = key - 48;
            if (number >= 1 && number <= 9) {
                if (number <= ServerConfigs.item.QUIVER_SLOTS.get()) {
                    NetworkHandler.INSTANCE.sendToServer((Object)new ServerBoundCycleQuiverPacket(number - 1, player.m_7655_() == InteractionHand.MAIN_HAND, true));
                }
                return true;
            }
        }
        return false;
    }

    private void renderSlot(int pX, int pY, Player pPlayer, ItemStack pStack, int seed) {
        if (!pStack.m_41619_()) {
            this.f_92987_.m_174229_((LivingEntity)pPlayer, pStack, pX, pY, seed);
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            this.f_92987_.m_115169_(this.f_92986_.f_91062_, pStack, pX, pY);
        }
    }

    public void renderQuiverContent(PoseStack poseStack, float partialTicks, int screenWidth, int screenHeight) {
        Player player;
        ItemStack quiver;
        Entity entity2 = this.f_92986_.m_91288_();
        if (entity2 instanceof Player && (quiver = (player = (Player)entity2).m_21211_()).m_41720_() == ModRegistry.QUIVER_ITEM.get()) {
            poseStack.m_85836_();
            QuiverItem.IQuiverData data = QuiverItem.getQuiverData(quiver);
            int selected = data.getSelectedSlot();
            List<ItemStack> items2 = data.getContentView();
            int slots = items2.size();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            int centerX = screenWidth / 2;
            int z = this.m_93252_();
            this.m_93250_(-90);
            int uWidth = slots * 20 + 2;
            int px = uWidth / 2;
            int py = screenHeight / 2 - 40;
            this.m_93228_(poseStack, centerX - (px += ((Integer)ClientConfigs.items.QUIVER_GUI_X.get()).intValue()), py += ((Integer)ClientConfigs.items.QUIVER_GUI_Y.get()).intValue(), 0, 0, uWidth - 1, 22);
            this.m_93228_(poseStack, centerX + px - 1, py, 0, 0, 1, 22);
            this.m_93228_(poseStack, centerX - px - 1 + selected * 20, py - 1, 24, 22, 24, 24);
            this.m_93250_(z);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            int i1 = 1;
            for (int i = 0; i < slots; ++i) {
                int kx = centerX - px + 3 + i * 20;
                this.renderSlot(kx, py + 3, player, items2.get(i), i1++);
            }
            RenderSystem.m_69461_();
            ItemStack selectedArrow = items2.get(selected);
            if (!selectedArrow.m_41619_()) {
                this.drawHighlight(poseStack, screenWidth, py, selectedArrow);
            }
            poseStack.m_85849_();
            QuiverArrowSelectGui.setActive(true);
            return;
        }
        QuiverArrowSelectGui.setActive(false);
    }

    protected void drawHighlight(PoseStack poseStack, int screenWidth, int py, ItemStack selectedArrow) {
        MutableComponent mutablecomponent = new TextComponent("").m_7220_(selectedArrow.m_41786_()).m_130938_(selectedArrow.m_41791_().getStyleModifier());
        if (selectedArrow.m_41788_()) {
            mutablecomponent.m_130940_(ChatFormatting.ITALIC);
        }
        Component highlightTip = selectedArrow.getHighlightTip((Component)mutablecomponent);
        int fontWidth = this.m_93082_().m_92852_((FormattedText)highlightTip);
        int nx = (screenWidth - fontWidth) / 2;
        int ny = py - 19;
        int l = 255;
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        Gui.m_93172_((PoseStack)poseStack, (int)(nx - 2), (int)(ny - 2), (int)(nx + fontWidth + 2), (int)(ny + 9 + 2), (int)this.f_92986_.f_91066_.m_92143_(0));
        Font font = this.m_93082_();
        nx = (screenWidth - font.m_92852_((FormattedText)highlightTip)) / 2;
        font.m_92763_(poseStack, highlightTip, (float)nx, (float)ny, 0xFFFFFF + (l << 24));
        RenderSystem.m_69461_();
    }

    public void render(ForgeIngameGui forgeGui, PoseStack poseStack, float partialTicks, int width, int height) {
        if (QuiverArrowSelectGui.isActive()) {
            this.renderQuiverContent(poseStack, partialTicks, width, height);
        }
    }

    static {
        lastCumulativeMouseDx = 0.0;
    }
}

