/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class RedPandaEntity
extends Animal
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ALERT = SynchedEntityData.m_135353_(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private Player alerter;

    public RedPandaEntity(EntityType<? extends RedPandaEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new RedPandaMoveControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 18.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(ALERT, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(2, (Goal)new AlertGoal());
        this.f_21345_.m_25352_(3, (Goal)new SleepGoal(140));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Sleeping", this.m_5803_());
        compound.m_128379_("Alert", this.isAlert());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setSleeping(compound.m_128471_("Sleeping"));
        this.setAlert(compound.m_128471_("Alert"));
    }

    protected int m_6552_(Player player) {
        return this.f_19796_.nextInt(2, 5);
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.6f : 1.0f;
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob ageableMob) {
        RedPandaEntity redPanda = (RedPandaEntity)((EntityType)CACEntities.RED_PANDA.get()).m_20615_((Level)level);
        return redPanda;
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return this.m_5803_() ? InteractionResult.PASS : super.m_6071_(player, interactionHand);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_150930_(Items.f_41911_);
    }

    protected SoundEvent m_7515_() {
        return this.m_5803_() ? null : (SoundEvent)CACSounds.RED_PANDA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)CACSounds.RED_PANDA_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CACSounds.RED_PANDA_DEATH.get();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag p_146750_) {
        spawnGroupData = super.m_6518_(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, p_146750_);
        if (mobSpawnType.equals((Object)MobSpawnType.SPAWNER) && ((AgeableMob.AgeableMobGroupData)spawnGroupData).m_146777_() >= 2 && this.f_19796_.nextFloat() <= 0.4f) {
            for (int i = 0; i < this.f_19796_.nextInt(1, 3); ++i) {
                RedPandaEntity baby = (RedPandaEntity)((EntityType)CACEntities.RED_PANDA.get()).m_20615_(this.f_19853_);
                baby.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
                baby.m_6863_(true);
                levelAccessor.m_7967_((Entity)baby);
            }
        }
        return spawnGroupData;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("red_panda_sleeping", Boolean.valueOf(true)));
        } else if (this.isAlert()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("red_panda_angry", Boolean.valueOf(false)));
        } else if (event.isMoving()) {
            if (this.f_20924_ >= 0.8f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("red_panda_run", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("red_panda_walk", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("red_panda_idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 4.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean isAlert() {
        return (Boolean)this.f_19804_.m_135370_(ALERT);
    }

    protected void setAlert(boolean alert) {
        this.f_19804_.m_135381_(ALERT, (Object)alert);
    }

    static class RedPandaMoveControl
    extends MoveControl {
        private final RedPandaEntity redPanda;

        public RedPandaMoveControl(RedPandaEntity redPandaEntity) {
            super((Mob)redPandaEntity);
            this.redPanda = redPandaEntity;
        }

        public void m_8126_() {
            if (!this.redPanda.m_5803_()) {
                super.m_8126_();
            }
        }
    }

    public class AlertGoal
    extends Goal {
        private int time;

        public AlertGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.time = AlertGoal.m_186073_((int)40);
        }

        public boolean m_8036_() {
            Player nearestPlayer;
            if (!RedPandaEntity.this.m_5803_() && (nearestPlayer = RedPandaEntity.this.f_19853_.m_45924_(RedPandaEntity.this.m_20185_(), RedPandaEntity.this.m_20186_(), RedPandaEntity.this.m_20189_(), 2.0, true)) != RedPandaEntity.this.alerter) {
                RedPandaEntity.this.alerter = nearestPlayer;
                return RedPandaEntity.this.alerter != null;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.time > 0;
        }

        public void m_8056_() {
            RedPandaEntity.this.setAlert(true);
            RedPandaEntity.this.m_21573_().m_26573_();
            RedPandaEntity.this.m_21566_().m_6849_(RedPandaEntity.this.m_20185_(), RedPandaEntity.this.m_20186_(), RedPandaEntity.this.m_20189_(), 0.0);
        }

        public void m_8037_() {
            RedPandaEntity.this.m_21563_().m_148051_((Entity)RedPandaEntity.this.alerter);
            --this.time;
        }

        public void m_8041_() {
            this.time = 20;
            RedPandaEntity.this.setAlert(false);
        }
    }

    public class SleepGoal
    extends Goal {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = RedPandaEntity.this.f_19796_.nextInt(SleepGoal.m_186073_((int)countdownTime));
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            if (RedPandaEntity.this.f_20900_ == 0.0f && RedPandaEntity.this.f_20901_ == 0.0f && RedPandaEntity.this.f_20902_ == 0.0f) {
                return this.canSleep() || RedPandaEntity.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return RedPandaEntity.this.f_19853_.m_46461_();
        }

        public void m_8041_() {
            RedPandaEntity.this.setSleeping(false);
            this.countdown = RedPandaEntity.this.f_19796_.nextInt(this.countdownTime);
        }

        public void m_8056_() {
            RedPandaEntity.this.m_6862_(false);
            RedPandaEntity.this.setSleeping(true);
            RedPandaEntity.this.m_21573_().m_26573_();
            RedPandaEntity.this.m_21566_().m_6849_(RedPandaEntity.this.m_20185_(), RedPandaEntity.this.m_20186_(), RedPandaEntity.this.m_20189_(), 0.0);
        }
    }
}

