/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.world.biome;

import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegisterPlacedFeature;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public abstract class BiomeMaker {
    public abstract Biome make();

    protected static int calculateSkyColor(float temperature) {
        float g = temperature / 3.0f;
        g = Mth.m_14036_((float)g, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - g * 0.05f), (float)(0.5f + g * 0.1f), (float)1.0f);
    }

    protected static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, MobSpawnSettings.Builder mobSpawnSettingsBuilder, BiomeGenerationSettings.Builder biomeGenerationSettingsBuilder, @Nullable Music music) {
        return BiomeMaker.biome(precipitation, temperature, downfall, 4159204, 329011, 12638463, mobSpawnSettingsBuilder, biomeGenerationSettingsBuilder, music);
    }

    protected static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, int waterColor, int waterFogColor, int fogColor, MobSpawnSettings.Builder mobSpawnSettingsBuilder, BiomeGenerationSettings.Builder biomeGenerationSettingsBuilder, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47595_(Biome.BiomeCategory.UNDERGROUND).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(fogColor).m_48040_(BiomeMaker.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(mobSpawnSettingsBuilder.m_48381_()).m_47601_(biomeGenerationSettingsBuilder.m_47831_()).m_47592_();
    }

    protected static void addUndergroundVarietyNoGlowLichen(BiomeGenerationSettings.Builder builder) {
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195323_);
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195324_);
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195325_);
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195326_);
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195327_);
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195328_);
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195329_);
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195330_);
        builder.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, OrePlacements.f_195331_);
    }

    protected static Holder<PlacedFeature> makeHolder(AutoRegisterPlacedFeature autoRegisterPlacedFeature) {
        return autoRegisterPlacedFeature.holder();
    }
}

