/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.services;

import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.NetworkModuleForge;
import com.yungnickyoung.minecraft.yungscavebiomes.network.IcicleShatterS2CPacket;
import com.yungnickyoung.minecraft.yungscavebiomes.network.SandstormSyncS2CPacket;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import com.yungnickyoung.minecraft.yungscavebiomes.services.IPlatformHelper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public void sendIcicleProjectileShatterS2CPacket(ServerLevel serverLevel, Vec3 pos) {
        ChunkAccess chunkAccess;
        if (serverLevel.m_46749_(new BlockPos(pos)) && (chunkAccess = serverLevel.m_46865_(new BlockPos(pos))) instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunkAccess;
            NetworkModuleForge.sendToClientsTrackingChunk(new IcicleShatterS2CPacket(pos), levelChunk);
        }
    }

    @Override
    public void syncSandstormDataToClients(SandstormServerData sandstormServerData) {
        NetworkModuleForge.sendToClientsInLevel(new SandstormSyncS2CPacket(sandstormServerData), (ResourceKey<Level>)sandstormServerData.getServerLevel().m_46472_());
    }

    @Override
    public void syncSandstormDataToPlayer(SandstormServerData sandstormServerData, ServerPlayer serverPlayer) {
        NetworkModuleForge.sendToClient(new SandstormSyncS2CPacket(sandstormServerData), serverPlayer);
    }

    @Override
    public Supplier<Item> getIceCubeSpawnEggItem() {
        return () -> new ForgeSpawnEggItem(() -> (EntityType)EntityTypeModule.ICE_CUBE.get(), 10798332, 15002876, new Item.Properties().m_41491_((CreativeModeTab)YungsCaveBiomesCommon.TAB_CAVEBIOMES.get()));
    }

    @Override
    public Supplier<Item> getSandSnapperSpawnEggItem() {
        return () -> new ForgeSpawnEggItem(() -> (EntityType)EntityTypeModule.SAND_SNAPPER.get(), 12223791, 13610069, new Item.Properties().m_41491_((CreativeModeTab)YungsCaveBiomesCommon.TAB_CAVEBIOMES.get()));
    }
}

