/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.mixin.debug;

import com.yungnickyoung.minecraft.yungscavebiomes.YungsCaveBiomesCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.mixin.debug.MobAccessor;
import com.yungnickyoung.minecraft.yungscavebiomes.mixin.debug.PathAccessor;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.Target;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DebugPackets.class})
public abstract class DebugPacketsMixin {
    @Shadow
    private static void m_133691_(ServerLevel $$0, FriendlyByteBuf $$1, ResourceLocation $$2) {
    }

    @Inject(method={"sendGoalSelector"}, at={@At(value="HEAD")})
    private static void yungscavebiomes_debugSendGoalSelector(Level level, Mob mob, GoalSelector goalSelector, CallbackInfo ci) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (YungsCaveBiomesCommon.DEBUG_RENDERING) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130064_(mob.m_142538_());
                buf.writeInt(mob.m_142049_());
                Set goals = ((MobAccessor)mob).getGoalSelector().m_148105_();
                buf.writeInt(goals.size());
                goals.stream().sorted((a, b) -> Integer.compare(b.m_26012_(), a.m_26012_())).forEach(goal -> {
                    buf.writeInt(goal.m_26012_());
                    buf.writeBoolean(goal.m_7620_());
                    buf.m_130070_(goal.m_26015_().toString());
                });
                DebugPacketsMixin.m_133691_(serverLevel, buf, ClientboundCustomPayloadPacket.f_132022_);
            }
        }
    }

    @Inject(method={"sendPathFindingPacket"}, at={@At(value="HEAD")})
    private static void yungscavebiomes_debugPathfinding(Level level, Mob mob, @Nullable Path path, float maxDistanceToWaypoint, CallbackInfo ci) {
        if (path == null) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (YungsCaveBiomesCommon.DEBUG_RENDERING) {
                if (((PathAccessor)path).getTargetNodes() == null || ((PathAccessor)path).getTargetNodes().isEmpty()) {
                    HashSet<Target> targetNodes = new HashSet<Target>();
                    targetNodes.add(new Target(0, 0, 0));
                    ((PathAccessor)path).setTargetNodes(targetNodes);
                }
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.writeInt(mob.m_142049_());
                buf.writeFloat(maxDistanceToWaypoint);
                path.m_164704_(buf);
                DebugPacketsMixin.m_133691_(serverLevel, buf, ClientboundCustomPayloadPacket.f_132013_);
            }
        }
    }
}

