/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;

public class SnapperTemptGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    private final TargetingConditions targetingConditions;
    protected final SandSnapperEntity sandSnapper;
    private final double speedModifier;
    private final float playerDist;
    private double px;
    private double py;
    private double pz;
    private double pRotX;
    private double pRotY;
    @Nullable
    protected Player player;
    private int calmDown;
    private final Ingredient items;
    private final boolean canScare;

    public SnapperTemptGoal(SandSnapperEntity sandSnapper, double speedModifier, Ingredient ingredient, boolean canScare, float playerDist) {
        this.sandSnapper = sandSnapper;
        this.speedModifier = speedModifier;
        this.items = ingredient;
        this.canScare = canScare;
        this.playerDist = playerDist;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
    }

    public boolean m_8036_() {
        if (this.calmDown > 0) {
            --this.calmDown;
            return false;
        }
        this.player = this.sandSnapper.f_19853_.m_45946_(this.targetingConditions, (LivingEntity)this.sandSnapper);
        return this.player != null;
    }

    public void m_8056_() {
        this.sandSnapper.setSubmerged(false);
        this.sandSnapper.setSubmergeLocked(true);
        this.px = this.player.m_20185_();
        this.py = this.player.m_20186_();
        this.pz = this.player.m_20189_();
    }

    public void m_8037_() {
        this.sandSnapper.m_21563_().m_24960_((Entity)this.player, (float)(this.sandSnapper.m_8085_() + 20), (float)this.sandSnapper.m_8132_());
        if (this.sandSnapper.m_20280_((Entity)this.player) < (double)(this.playerDist * this.playerDist)) {
            this.sandSnapper.m_21573_().m_26573_();
        } else {
            this.sandSnapper.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
        }
    }

    public boolean m_8045_() {
        if (this.canScare) {
            if (this.sandSnapper.m_20280_((Entity)this.player) < 36.0) {
                if (this.player.m_20275_(this.px, this.py, this.pz) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.player.m_146909_() - this.pRotX) > 5.0 || Math.abs((double)this.player.m_146908_() - this.pRotY) > 5.0) {
                    return false;
                }
            } else {
                this.px = this.player.m_20185_();
                this.py = this.player.m_20186_();
                this.pz = this.player.m_20189_();
            }
            this.pRotX = this.player.m_146909_();
            this.pRotY = this.player.m_146908_();
        }
        return this.m_8036_();
    }

    public void m_8041_() {
        this.sandSnapper.setEating(false);
        this.sandSnapper.setSubmergeLocked(false);
        this.player = null;
        this.sandSnapper.m_21573_().m_26573_();
        this.calmDown = SnapperTemptGoal.m_186073_((int)100);
    }

    private boolean shouldFollow(LivingEntity livingEntity) {
        return this.items.test(livingEntity.m_21205_()) || this.items.test(livingEntity.m_21206_());
    }
}

