/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.goal;

import com.yungnickyoung.minecraft.yungscavebiomes.block.PricklyPeachCactusBlock;
import com.yungnickyoung.minecraft.yungscavebiomes.entity.sand_snapper.SandSnapperEntity;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.ISandstormServerDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.sandstorm.SandstormServerData;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class EatPricklyPeachCactusGoal
extends Goal {
    private final SandSnapperEntity sandSnapper;
    private final int horizontalRange;
    private final int verticalRange;
    private final float playerDist;
    private final float eatRange;
    private Vec3 cactusPos;
    private int eatingTimer;
    private static final int EAT_LENGTH = 31;

    public EatPricklyPeachCactusGoal(SandSnapperEntity sandSnapper, int horizontalRange, int verticalRange, float playerDist, float eatRange) {
        this.sandSnapper = sandSnapper;
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
        this.playerDist = playerDist;
        this.eatRange = eatRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public void m_8056_() {
        this.sandSnapper.setSubmerged(false);
        this.sandSnapper.setSubmergeLocked(true);
        this.sandSnapper.m_21573_().m_26519_(this.cactusPos.f_82479_, this.cactusPos.f_82480_, this.cactusPos.f_82481_, 1.0);
    }

    public void m_8041_() {
        this.sandSnapper.setEating(false);
        this.sandSnapper.setSubmergeLocked(false);
        if (this.sandSnapper.cactusEatCooldownTimer <= 0) {
            this.sandSnapper.cactusEatCooldownTimer = 200;
        }
    }

    public void m_8037_() {
        if (this.sandSnapper.m_20238_(this.cactusPos) > (double)(this.eatRange * this.eatRange) && this.sandSnapper.m_21573_().m_26571_()) {
            if (this.sandSnapper.isEating()) {
                this.sandSnapper.setEating(false);
            }
            this.sandSnapper.m_21573_().m_26519_(this.cactusPos.f_82479_, this.cactusPos.f_82480_, this.cactusPos.f_82481_, 1.0);
        } else if (this.sandSnapper.m_20238_(this.cactusPos) <= (double)(this.eatRange * this.eatRange) && !this.sandSnapper.isEating()) {
            this.sandSnapper.setEating(true);
            this.eatingTimer = 31;
        }
        if (this.sandSnapper.isEating()) {
            --this.eatingTimer;
            if (this.eatingTimer <= 0) {
                this.sandSnapper.setEating(false);
                this.sandSnapper.eatCactus(new BlockPos(this.cactusPos));
                this.sandSnapper.cactusEatCooldownTimer = 6000;
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8036_() {
        if (this.sandSnapper.isOnCactusEatCooldown()) {
            return false;
        }
        ArrayList cactusPositions = new ArrayList();
        BlockPos.m_121976_((int)(this.sandSnapper.m_142538_().m_123341_() - this.horizontalRange), (int)(this.sandSnapper.m_142538_().m_123342_() - this.verticalRange), (int)(this.sandSnapper.m_142538_().m_123343_() - this.horizontalRange), (int)(this.sandSnapper.m_142538_().m_123341_() + this.horizontalRange), (int)(this.sandSnapper.m_142538_().m_123342_() + this.verticalRange), (int)(this.sandSnapper.m_142538_().m_123343_() + this.horizontalRange)).forEach(p -> {
            BlockState state = this.sandSnapper.f_19853_.m_8055_(p);
            if (state.m_60713_((Block)BlockModule.PRICKLY_PEACH_CACTUS.get()) && ((Boolean)state.m_61143_((Property)PricklyPeachCactusBlock.FRUIT)).booleanValue()) {
                cactusPositions.add(new BlockPos((Vec3i)p));
            }
        });
        if (cactusPositions.isEmpty()) {
            return false;
        }
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.f_19853_).getSandstormServerData();
        if (!sandstormServerData.isSandstormActive()) {
            for (BlockPos pos : cactusPositions) {
                Player nearestPlayer = this.sandSnapper.m_183503_().m_45924_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)this.playerDist, true);
                if (nearestPlayer != null) continue;
                this.cactusPos = Vec3.m_82512_((Vec3i)pos);
                return true;
            }
        } else {
            this.cactusPos = Vec3.m_82512_((Vec3i)((Vec3i)cactusPositions.get(0)));
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.sandSnapper.isOnCactusEatCooldown()) {
            return false;
        }
        BlockState state = this.sandSnapper.f_19853_.m_8055_(new BlockPos(this.cactusPos));
        if (!state.m_60713_((Block)BlockModule.PRICKLY_PEACH_CACTUS.get()) || !((Boolean)state.m_61143_((Property)PricklyPeachCactusBlock.FRUIT)).booleanValue()) {
            return false;
        }
        SandstormServerData sandstormServerData = ((ISandstormServerDataProvider)this.sandSnapper.f_19853_).getSandstormServerData();
        if (!sandstormServerData.isSandstormActive()) {
            Player nearestPlayer = this.sandSnapper.m_183503_().m_45924_(this.cactusPos.m_7096_(), this.cactusPos.m_7098_(), this.cactusPos.m_7094_(), (double)this.playerDist, true);
            return nearestPlayer == null;
        }
        return true;
    }

    public boolean m_6767_() {
        return false;
    }
}

