/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.client.particle;

import com.mojang.math.Vector3f;
import com.yungnickyoung.minecraft.yungscavebiomes.client.render.sandstorm.ISandstormClientDataProvider;
import com.yungnickyoung.minecraft.yungscavebiomes.client.render.sandstorm.SandstormClientData;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class SandstormParticle
extends TextureSheetParticle {
    private final float rotSpeed;
    private final SpriteSet sprites;
    private Vector3f particleSpeedVector;

    SandstormParticle(ClientLevel clientLevel, double xo, double yo, double zo, float r, float g, float b, SpriteSet spriteSet) {
        super(clientLevel, xo, yo, zo);
        this.sprites = spriteSet;
        this.f_107227_ = r;
        this.f_107228_ = g;
        this.f_107229_ = b;
        this.f_107225_ = Mth.m_144928_((Random)clientLevel.m_5822_(), (int)32, (int)48);
        this.f_107224_ = Mth.m_144928_((Random)clientLevel.m_5822_(), (int)0, (int)32);
        this.m_108339_(spriteSet);
        this.rotSpeed = (float)Math.random() * 0.15f + 0.05f;
        this.f_107231_ = (float)Math.random() * ((float)Math.PI * 2);
        this.f_107226_ = 0.0f;
        this.particleSpeedVector = new Vector3f();
        this.updateSpeed();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public float m_5902_(float f) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + f) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        this.m_108339_(this.sprites);
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += (float)Math.PI * this.rotSpeed * 2.0f;
        if (this.f_107218_) {
            this.f_107231_ = 0.0f;
            this.f_107204_ = 0.0f;
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.updateSpeed();
    }

    private void updateSpeed() {
        SandstormClientData sandstormClientData = ((ISandstormClientDataProvider)this.f_107208_).getSandstormClientData();
        this.particleSpeedVector = sandstormClientData.getSandstormParticleSpeedVector(this.f_107209_, this.f_107210_, this.f_107211_, this.particleSpeedVector);
        this.m_172260_(this.particleSpeedVector.m_122239_(), this.particleSpeedVector.m_122260_(), this.particleSpeedVector.m_122269_());
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel clientLevel, double xo, double yo, double zo, double dx, double dy, double dz) {
            int color = 13743234;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            return new SandstormParticle(clientLevel, xo, yo, zo, r, g, b, this.spriteSet);
        }
    }
}

