/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.client;

import com.yungnickyoung.minecraft.yungscavebiomes.client.YungsCaveBiomesClientCommon;
import com.yungnickyoung.minecraft.yungscavebiomes.client.model.IceCubeModel;
import com.yungnickyoung.minecraft.yungscavebiomes.client.particle.FallingAncientDustParticle;
import com.yungnickyoung.minecraft.yungscavebiomes.client.particle.IceShatterParticle;
import com.yungnickyoung.minecraft.yungscavebiomes.client.particle.LostCavesAmbientParticle;
import com.yungnickyoung.minecraft.yungscavebiomes.client.particle.SandstormParticle;
import com.yungnickyoung.minecraft.yungscavebiomes.client.render.BuffetedOverlay;
import com.yungnickyoung.minecraft.yungscavebiomes.client.render.IceCubeRenderer;
import com.yungnickyoung.minecraft.yungscavebiomes.client.render.IcicleProjectileRenderer;
import com.yungnickyoung.minecraft.yungscavebiomes.client.render.SandSnapperRenderer;
import com.yungnickyoung.minecraft.yungscavebiomes.module.BlockModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.EntityTypeModule;
import com.yungnickyoung.minecraft.yungscavebiomes.module.ParticleTypeModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class YungsCaveBiomesClientForge {
    public static void init() {
        YungsCaveBiomesClientCommon.init();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(YungsCaveBiomesClientForge::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(YungsCaveBiomesClientForge::registerLayerDefinitions);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(YungsCaveBiomesClientForge::registerRenderers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(YungsCaveBiomesClientForge::registerParticleFactories);
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        IIngameOverlay buffetedOverlay = (gui, poseStack, partialTick, screenWidth, screenHeight) -> {
            gui.setupOverlayRenderState(true, false);
            BuffetedOverlay.render(poseStack, partialTick, screenWidth, screenHeight);
        };
        OverlayRegistry.registerOverlayTop((String)"Buffeted", (IIngameOverlay)buffetedOverlay);
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.ICICLE.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.FROST_LILY.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.RARE_ICE.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.ICE_SHEET.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.PRICKLY_PEACH_CACTUS.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.POTTED_PRICKLY_PEACH_CACTUS.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.PRICKLY_VINES.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)BlockModule.PRICKLY_VINES_PLANT.get()), (RenderType)RenderType.m_110463_());
        });
    }

    private static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(IceCubeRenderer.LAYER_LOCATION, IceCubeModel::createBodyLayer);
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)EntityTypeModule.ICE_CUBE.get(), IceCubeRenderer::new);
        event.registerEntityRenderer((EntityType)EntityTypeModule.SAND_SNAPPER.get(), SandSnapperRenderer::new);
        event.registerEntityRenderer((EntityType)EntityTypeModule.ICICLE.get(), IcicleProjectileRenderer::new);
    }

    private static void registerParticleFactories(ParticleFactoryRegisterEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleTypeModule.ANCIENT_DUST.get(), FallingAncientDustParticle.Provider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleTypeModule.SANDSTORM.get(), SandstormParticle.Provider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleTypeModule.LOST_CAVES_AMBIENT.get(), LostCavesAmbientParticle.Provider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)ParticleTypeModule.ICE_SHATTER.get(), IceShatterParticle.Provider::new);
    }
}

