/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.world.biome;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.Climate;
import org.apache.commons.lang3.mutable.MutableInt;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.overworld.BYGOverworldBiomeBuilder;
import potionstudios.byg.common.world.biome.overworld.OverworldRegion;
import potionstudios.byg.mixin.access.OverworldBiomeBuilderAccess;
import potionstudios.byg.util.BYGRegionUtils;
import potionstudios.byg.util.BYGUtil;
import terrablender.api.Region;
import terrablender.api.RegionType;

public class BYGTerraBlenderRegion
extends Region {
    private static int count = 0;
    private final Set<ResourceKey<Biome>> bygKeys = new ObjectOpenHashSet();
    private final Map<ResourceKey<Biome>, ResourceKey<Biome>> swapper;
    private final BYGOverworldBiomeBuilder bygOverworldBiomeBuilder;

    public BYGTerraBlenderRegion(OverworldRegion overworldRegion) {
        this(overworldRegion.overworldWeight(), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.oceans().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.middleBiomes().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.middleBiomesVariant().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.plateauBiomes().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.plateauBiomesVariant().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.extremeHills().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.beachBiomes().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.peakBiomes().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.peakBiomesVariant().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.slopeBiomes().value()), BYGUtil._2DResourceKeyArrayTo2DList(overworldRegion.slopeBiomesVariant().value()), overworldRegion.swapper());
    }

    public BYGTerraBlenderRegion(int overworldWeight, ResourceKey<Biome>[][] oceans, ResourceKey<Biome>[][] middleBiomes, ResourceKey<Biome>[][] middleBiomesVariant, ResourceKey<Biome>[][] plateauBiomes, ResourceKey<Biome>[][] plateauBiomesVariant, ResourceKey<Biome>[][] shatteredBiomes, ResourceKey<Biome>[][] beachBiomes, ResourceKey<Biome>[][] peakBiomes, ResourceKey<Biome>[][] peakBiomesVariant, ResourceKey<Biome>[][] slopeBiomes, ResourceKey<Biome>[][] slopeBiomesVariant, Map<ResourceKey<Biome>, ResourceKey<Biome>> swapper) {
        super(BYG.createLocation("region_" + count++), RegionType.OVERWORLD, overworldWeight);
        this.swapper = swapper;
        Predicate<ResourceKey<Biome>> noVoidBiomes = biomeResourceKey -> biomeResourceKey != Biomes.f_48173_;
        oceans = BYGRegionUtils.filter("oceans", this.getName(), count, oceans, noVoidBiomes, true);
        middleBiomes = BYGRegionUtils.filter("middle_biomes", this.getName(), count, middleBiomes, noVoidBiomes, true);
        middleBiomesVariant = BYGRegionUtils.filter("middle_biomes_variant", this.getName(), count, middleBiomesVariant, noVoidBiomes, false);
        plateauBiomes = BYGRegionUtils.filter("plateau_biomes", this.getName(), count, plateauBiomes, noVoidBiomes, true);
        plateauBiomesVariant = BYGRegionUtils.filter("plateau_biomes_variant", this.getName(), count, plateauBiomesVariant, noVoidBiomes, false);
        shatteredBiomes = BYGRegionUtils.filter("shattered_biomes", this.getName(), count, shatteredBiomes, noVoidBiomes, false);
        beachBiomes = BYGRegionUtils.filter("beach_biomes", this.getName(), count, beachBiomes, noVoidBiomes, true);
        peakBiomes = BYGRegionUtils.filter("peak_biomes", this.getName(), count, peakBiomes, noVoidBiomes, true);
        peakBiomesVariant = BYGRegionUtils.filter("peak_biomes_variant", this.getName(), count, peakBiomesVariant, noVoidBiomes, false);
        slopeBiomes = BYGRegionUtils.filter("slope_biomes", this.getName(), count, slopeBiomes, noVoidBiomes, true);
        slopeBiomesVariant = BYGRegionUtils.filter("slope_biomes_variant", this.getName(), count, slopeBiomesVariant, noVoidBiomes, false);
        this.bygOverworldBiomeBuilder = new BYGOverworldBiomeBuilder(oceans, middleBiomes, middleBiomesVariant, plateauBiomes, plateauBiomesVariant, shatteredBiomes, beachBiomes, peakBiomes, peakBiomesVariant, slopeBiomes, slopeBiomesVariant);
        BYGRegionUtils.dumpArrays(biomeResourceKey -> {
            if (biomeResourceKey != null) {
                this.bygKeys.add((ResourceKey<Biome>)biomeResourceKey);
                if (swapper.containsValue(biomeResourceKey)) {
                    throw new IllegalArgumentException("Swapper cannot contain elements found in the temperature arrays.");
                }
            }
        }, oceans, middleBiomes, middleBiomesVariant, plateauBiomes, plateauBiomesVariant, shatteredBiomes, beachBiomes, peakBiomes);
    }

    public void addBiomes(Registry<Biome> registry, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        boolean sanityCheck;
        MutableInt totalPairs = new MutableInt();
        MutableInt bygMapperAccepted = new MutableInt(0);
        ((OverworldBiomeBuilderAccess)((Object)this.bygOverworldBiomeBuilder)).byg_invokeAddBiomes(parameterPointResourceKeyPair -> {
            ResourceKey biomeKey = (ResourceKey)parameterPointResourceKeyPair.getSecond();
            if (!registry.m_142003_(biomeKey)) {
                throw new IllegalArgumentException(String.format("\"%s\" is not a valid biome in the world registry!", biomeKey.m_135782_().toString()));
            }
            totalPairs.increment();
            boolean mapped = false;
            boolean alreadyMappedOutsideSwapper = false;
            if (this.bygKeys.contains(biomeKey)) {
                mapper.accept(new Pair((Object)((Climate.ParameterPoint)parameterPointResourceKeyPair.getFirst()), (Object)biomeKey));
                bygMapperAccepted.increment();
                alreadyMappedOutsideSwapper = true;
                mapped = true;
            }
            if (this.swapper.containsKey(biomeKey)) {
                if (alreadyMappedOutsideSwapper) {
                    throw new UnsupportedOperationException(String.format("Attempting to assign a biome resource key in both the swapper and biome selectors. We're crashing your game to let you know that \"%s\" was put in the biome selectors but will always be swapped by \"%s\" due to the swapper. In region \"%s\".", biomeKey.m_135782_().toString(), this.swapper.get(biomeKey).m_135782_().toString(), this.getName().toString()));
                }
                mapper.accept(new Pair((Object)((Climate.ParameterPoint)parameterPointResourceKeyPair.getFirst()), this.swapper.get(biomeKey)));
                bygMapperAccepted.increment();
                mapped = true;
            }
            if (!mapped) {
                mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)parameterPointResourceKeyPair);
                bygMapperAccepted.increment();
            }
        });
        int totalPairsValue = totalPairs.intValue();
        int mapperAcceptValue = bygMapperAccepted.intValue();
        boolean bl = sanityCheck = totalPairsValue != mapperAcceptValue;
        if (sanityCheck) {
            throw new UnsupportedOperationException(String.format("Not all biome parameter points were accepted for BYG Terrablender biome region: %s. %s/%s were accepted.", this.getName().toString(), totalPairsValue, mapperAcceptValue));
        }
    }
}

