/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.text.WordUtils;
import potionstudios.byg.BYG;

public class LangFileGenerator {
    public static final Map<Class<?>, String> TYPE_ID = (Map)Util.m_137469_(new HashMap(), map -> {
        map.put(EntityType.class, "entity");
        map.put(Biome.class, "biome");
        map.put(Block.class, "block");
        map.put(Item.class, "item");
        map.put(MobEffect.class, "effect");
    });
    public static final Map<String, String> MISC_LANG_ENTRIES = (Map)Util.m_137469_(new TreeMap(), map -> {
        InputStream resourceAsStream = Language.class.getResourceAsStream("/assets/byg/lang/en_us_misc.json");
        if (resourceAsStream != null) {
            map.putAll((Map)new Gson().fromJson((Reader)new InputStreamReader(resourceAsStream), TreeMap.class));
        }
    });

    public static void createLangFile(Path path) {
        TreeMap<String, String> lang = new TreeMap<String, String>(MISC_LANG_ENTRIES);
        for (Registry registry : Registry.f_122897_) {
            LangFileGenerator.yes(registry, lang);
        }
        for (Registry registry : BuiltinRegistries.f_123858_) {
            LangFileGenerator.yes(registry, lang);
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(lang).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BYG.LOGGER.error(e.toString());
        }
    }

    private static <T> void yes(Registry<T> registry, Map<String, String> map) {
        for (Object value : registry) {
            ResourceLocation key = registry.m_7981_(value);
            if (!key.m_135827_().equals("byg")) continue;
            TYPE_ID.forEach((aClass, s) -> {
                if (aClass.isAssignableFrom(value.getClass())) {
                    String id = Util.m_137492_((String)s, (ResourceLocation)key);
                    map.put(id, WordUtils.capitalize((String)key.m_135815_().replace("_", " ")));
                }
            });
        }
    }
}

