/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.server.command;

import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.Function;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.HashCache;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.PrimaryLevelData;
import potionstudios.byg.BYG;
import potionstudios.byg.mixin.access.WorldGenRegistryDumpReportAccess;
import potionstudios.byg.shadow.blue.endless.jankson.Jankson;
import potionstudios.byg.shadow.blue.endless.jankson.JsonObject;
import potionstudios.byg.shadow.blue.endless.jankson.api.SyntaxError;
import potionstudios.byg.util.ModPlatform;
import potionstudios.byg.util.jankson.JanksonUtil;

public class WorldGenExportCommand {
    private static final String EXCLUDED = Paths.get("minecraft", new String[0]).resolve("worldgen").resolve("density_function").resolve("zero.json").toString();
    public static final Map<String, String> COMMENTS = (Map)Util.m_137469_(new HashMap(), map -> {});

    public static void worldGenExportCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        String commandString = "worldGenExport";
        Function withComments = cs -> (Boolean)((CommandContext)cs).getArgument("With comments?", Boolean.class);
        Function builtin = cs -> (Boolean)((CommandContext)cs).getArgument("Generate Built In Registries?", Boolean.class);
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).requires(stack -> stack.m_6761_(4))).executes(cs -> WorldGenExportCommand.generateWorldGenExport(true, false, (CommandContext<CommandSourceStack>)cs))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"With comments?", (ArgumentType)BoolArgumentType.bool()).executes(cs -> WorldGenExportCommand.generateWorldGenExport((Boolean)withComments.apply((Object)cs), false, (CommandContext<CommandSourceStack>)cs))).then(Commands.m_82129_((String)"Generate Built In Registries?", (ArgumentType)BoolArgumentType.bool()).executes(cs -> WorldGenExportCommand.generateWorldGenExport((Boolean)withComments.apply((Object)cs), (Boolean)builtin.apply((Object)cs), (CommandContext<CommandSourceStack>)cs)))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)commandString).redirect((CommandNode)source));
    }

    public static int generateWorldGenExport(boolean withComments, boolean builtin, CommandContext<CommandSourceStack> commandSource) {
        CommandSourceStack source = (CommandSourceStack)commandSource.getSource();
        if (!source.m_81377_().m_129792_() || source.m_81377_().m_7416_() > 1) {
            source.m_81352_((Component)new TranslatableComponent("byg.worldgenexport.singleplayer").m_130940_(ChatFormatting.RED));
            return 0;
        }
        Path finalExportPath = ModPlatform.INSTANCE.configPath().getParent().resolve("world_gen_export").resolve(builtin ? "builtin" : "world").resolve("data");
        Path exportPath = finalExportPath.resolve("cache");
        MutableComponent exportFileComponent = new TextComponent(finalExportPath.toString()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(text -> text.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, finalExportPath.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("byg.clickevent.hovertext"))));
        if (exportPath.toFile().exists()) {
            source.m_81352_((Component)new TranslatableComponent("byg.worldgenexport.exists", new Object[]{exportFileComponent}).m_130940_(ChatFormatting.RED));
            return 0;
        }
        source.m_81354_((Component)new TranslatableComponent("byg.worldgenexport.starting").m_130940_(ChatFormatting.YELLOW), true);
        try {
            WorldGenExportCommand.generateFiles(builtin, source, exportPath);
            if (withComments) {
                WorldGenExportCommand.addComments(exportPath);
            }
            WorldGenExportCommand.setupAndUseDataPackDirectoriesStructure(finalExportPath, exportPath);
            WorldGenExportCommand.createPackMCMeta(finalExportPath.getParent(), builtin);
            source.m_81354_((Component)new TranslatableComponent("byg.worldgenexport.success", new Object[]{exportFileComponent}).m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }
        catch (IOException e) {
            source.m_81352_((Component)new TranslatableComponent("byg.worldgenexport.failed"));
            e.printStackTrace();
            return 0;
        }
    }

    private static void setupAndUseDataPackDirectoriesStructure(Path finalExportPath, Path exportPath) throws IOException {
        Path result = exportPath.resolve("reports").resolve("worldgen");
        Files.walk(result, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
            try {
                if (path.getFileName().toString().endsWith(".json")) {
                    String newTarget = result.relativize((Path)path).toString();
                    Path newPath = finalExportPath.resolve(newTarget);
                    Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                    byte[] bytes = Files.readAllBytes(path);
                    Files.write(newPath, bytes, new OpenOption[0]);
                }
                Files.delete(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        Files.walk(exportPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static void addComments(Path exportPath) throws IOException {
        Files.walk(exportPath, new FileVisitOption[0]).forEach(path -> {
            boolean skipZero;
            String fileName = path.getFileName().toString();
            boolean bl = skipZero = !path.toString().endsWith(EXCLUDED);
            if (fileName.endsWith(".json") && skipZero) {
                try {
                    JsonObject load = Jankson.builder().build().load(path.toFile());
                    load = JanksonUtil.addCommentsAndAlphabeticallySortRecursively(COMMENTS, load, "", true);
                    Files.write(path, load.toJson(JanksonUtil.JSON_GRAMMAR).getBytes(), new OpenOption[0]);
                }
                catch (IOException | SyntaxError e) {
                    BYG.LOGGER.error(String.format("\"%s\" had errors: ", path.toString()));
                    e.printStackTrace();
                }
            }
        });
    }

    private static void generateFiles(boolean builtin, CommandSourceStack source, Path exportPath) throws IOException {
        HashCache cache = new HashCache(exportPath, "cache");
        RegistryAccess.Writable registry = builtin ? RegistryAccess.m_206197_() : source.m_81372_().m_5962_();
        Registry defaultDimensions = DimensionType.m_204493_((RegistryAccess)registry, (long)0L, (boolean)false);
        NoiseBasedChunkGenerator chunkGenerator = WorldGenSettings.m_190039_((RegistryAccess)registry, (long)0L, (boolean)false);
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registry);
        for (RegistryAccess.RegistryData knownRegistry : RegistryAccess.m_194613_()) {
            WorldGenRegistryDumpReportAccess.byg_invokeDumpRegistryCap(cache, exportPath, (RegistryAccess)registry, (DynamicOps<JsonElement>)ops, knownRegistry);
        }
        Registry worldSettings = builtin ? WorldGenSettings.m_204649_((Registry)registry.m_206191_(Registry.f_122818_), (Registry)defaultDimensions, (ChunkGenerator)chunkGenerator) : ((PrimaryLevelData)source.m_81377_().m_129880_(Level.f_46428_).m_6106_()).m_5961_().m_204655_();
        WorldGenRegistryDumpReportAccess.byg_invokeDumpRegistry(exportPath, cache, (DynamicOps<JsonElement>)ops, Registry.f_122820_, worldSettings, LevelStem.f_63970_);
    }

    private static void createPackMCMeta(Path path, boolean builtIn) throws IOException {
        String fileString = "{\n\t\"pack\":{\n\t\t\"pack_format\": 9,\n\t\t\"description\": \" Generated world gen datapack from " + (builtIn ? "built in registries" : "current world registries") + ".\"\n\t}\n}\n";
        Files.write(path.resolve("pack.mcmeta"), fileString.getBytes(), new OpenOption[0]);
    }
}

