/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import potionstudios.byg.client.BiomepediaInventoryConfig;
import potionstudios.byg.common.block.sapling.GrowingPatterns;
import potionstudios.byg.common.entity.npc.TradesConfig;
import potionstudios.byg.common.world.biome.end.EndBiomesConfig;
import potionstudios.byg.common.world.biome.nether.NetherBiomesConfig;
import potionstudios.byg.common.world.surfacerules.SurfaceRulesConfig;
import potionstudios.byg.config.BiomepediaConfig;
import potionstudios.byg.config.ConfigVersionTracker;
import potionstudios.byg.config.SettingsConfig;
import potionstudios.byg.config.json.BiomeDictionaryConfig;
import potionstudios.byg.config.json.OverworldBiomeConfig;
import potionstudios.byg.util.FeatureGrowerFromBlockPattern;
import potionstudios.byg.util.ModPlatform;

public class BYGConfigHandler {
    public static String loadAllConfigs(boolean serialize, boolean recreate) {
        return BYGConfigHandler.loadAllConfigs(serialize, recreate, ModPlatform.INSTANCE.isClientEnvironment());
    }

    public static String loadAllConfigs(boolean serialize, boolean recreate, boolean isClientSide) {
        StringBuilder errors = new StringBuilder();
        errors.append(BYGConfigHandler.tryCatchErrors(() -> EndBiomesConfig.getConfig(serialize, recreate, null)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> NetherBiomesConfig.getConfig(serialize, recreate, null)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> OverworldBiomeConfig.getConfig(serialize, recreate)));
        if (ModPlatform.INSTANCE.modPlatform() == ModPlatform.Platform.FORGE) {
            errors.append(BYGConfigHandler.tryCatchErrors(() -> BiomeDictionaryConfig.getConfig(serialize, recreate)));
        }
        errors.append(BYGConfigHandler.tryCatchErrors(() -> SurfaceRulesConfig.getConfig(serialize, recreate)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> {
            GrowingPatterns.getConfig(serialize, recreate);
            FeatureGrowerFromBlockPattern.ENTRIES.forEach(c -> ((FeatureGrowerFromBlockPattern)c.get()).load());
        }));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> TradesConfig.getConfig(serialize, recreate)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> SettingsConfig.getConfig(serialize, recreate)));
        if (isClientSide) {
            errors.append(BYGConfigHandler.tryCatchErrors(() -> BiomepediaInventoryConfig.getConfig(serialize, recreate)));
        }
        errors.append(BYGConfigHandler.tryCatchErrors(() -> BiomepediaConfig.getConfig(serialize, recreate)));
        errors.append(BYGConfigHandler.tryCatchErrors(() -> ConfigVersionTracker.getConfig(new ConfigVersionTracker(4), recreate)));
        errors.append(BYGConfigHandler.tryCatchErrors(BYGConfigHandler::makeREADME));
        if (!errors.isEmpty()) {
            return String.format("Config errors were found:\n\n%s", errors.toString());
        }
        return errors.toString();
    }

    private static String tryCatchErrors(Runnable run) {
        String error = "";
        try {
            run.run();
        }
        catch (Exception e) {
            error = e.getMessage();
        }
        if (error == null) {
            return "";
        }
        return error + (!error.isEmpty() ? "\n" : "");
    }

    private static void makeREADME() {
        try {
            Path configPath = ModPlatform.INSTANCE.configPath();
            Files.createDirectories(configPath, new FileAttribute[0]);
            Files.write(configPath.resolve("README.txt"), "For information on how BYG configs work, you can find that here: https://github.com/AOCAWOL/BYG/wiki/Configs".getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

