/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.util;

import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import potionstudios.byg.BYG;
import potionstudios.byg.common.world.biome.end.BYGEndBiomeSource;
import potionstudios.byg.common.world.biome.end.EndBiomesConfig;
import potionstudios.byg.common.world.biome.nether.BYGNetherBiomeSource;
import potionstudios.byg.common.world.biome.nether.NetherBiomesConfig;
import potionstudios.byg.mixin.access.BiomeSourceAccess;
import potionstudios.byg.mixin.access.ChunkGeneratorAccess;
import potionstudios.byg.util.ModPlatform;

public class BiomeSourceRepairUtils {
    public static void repairBiomeSources(Registry<Biome> biomeRegistry, WorldGenSettings worldGenSettings) {
        EndBiomesConfig endBiomesConfig;
        NetherBiomesConfig netherBiomesConfig = NetherBiomesConfig.getConfig(true, false, biomeRegistry);
        if (netherBiomesConfig.forceBYGNetherBiomeSource()) {
            Supplier<BiomeSource> netherBiomeSource = () -> ModPlatform.INSTANCE.createNetherBiomeSource(biomeRegistry, worldGenSettings.m_64619_());
            LevelStem levelStem = (LevelStem)worldGenSettings.m_204655_().m_6246_(LevelStem.f_63972_);
            if (levelStem == null) {
                BYG.LOGGER.error(String.format("Unable to find level stem/dimension \"%s\", this is most likely due to a world being moved across minecraft versions, Oh The Biomes You'll Go cannot support this operation.\nSkipping biome source repair....", LevelStem.f_63972_));
            } else {
                BiomeSourceRepairUtils.repair(levelStem, BYGNetherBiomeSource.LOCATION, netherBiomeSource);
            }
        }
        if ((endBiomesConfig = EndBiomesConfig.getConfig(true, false, biomeRegistry)).forceBYGEndBiomeSource()) {
            Supplier<BiomeSource> endBiomeSource = () -> ModPlatform.INSTANCE.createEndBiomeSource(biomeRegistry, worldGenSettings.m_64619_());
            LevelStem levelStem = (LevelStem)worldGenSettings.m_204655_().m_6246_(LevelStem.f_63973_);
            if (levelStem == null) {
                BYG.LOGGER.error(String.format("Unable to find level stem/dimension \"%s\", this is most likely due to a world being moved across minecraft versions, Oh The Biomes You'll Go cannot support this operation.\nSkipping biome source repair....", LevelStem.f_63973_));
            } else {
                BiomeSourceRepairUtils.repair(levelStem, BYGEndBiomeSource.LOCATION, endBiomeSource);
            }
        }
    }

    private static boolean repair(LevelStem dimension, ResourceLocation targetBiomeSourceID, Supplier<BiomeSource> replacement) {
        ChunkGenerator generator = dimension.m_63990_();
        Codec<? extends BiomeSource> codec = ((BiomeSourceAccess)generator.m_62218_()).byg_invokeCodec();
        if (!Registry.f_122889_.m_7981_(codec).equals((Object)targetBiomeSourceID)) {
            BiomeSource replacementBiomeSource = replacement.get();
            ((ChunkGeneratorAccess)generator).byg_setBiomeSource(replacementBiomeSource);
            ((ChunkGeneratorAccess)generator).byg_setRuntimeBiomeSource(replacementBiomeSource);
            return true;
        }
        return false;
    }
}

