/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure.arch;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.util.blendingfunction.BlendingFunction;

public record ArchConfiguration(IntProvider height, IntProvider length, IntProvider width, SimpleWeightedRandomList<BlendingFunction> blendingFunction, FloatProvider matchingBlendingFunctionChance, FloatProvider percentageDestroyed, NoisySphereConfig sphereConfig, TagKey<Biome> biomeEnforcement) implements FeatureConfiguration
{
    public static final TagKey<Biome> EMPTY = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("empty", "empty"));
    public static final Codec<ArchConfiguration> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)IntProvider.f_146531_.fieldOf("height").forGetter(archConfiguration -> archConfiguration.height), (App)IntProvider.f_146533_.fieldOf("length").forGetter(archConfiguration -> archConfiguration.length), (App)IntProvider.f_146533_.fieldOf("width").forGetter(archConfiguration -> archConfiguration.width), (App)SimpleWeightedRandomList.m_146264_(BlendingFunction.CODEC).fieldOf("blending_functions").forGetter(archConfiguration -> archConfiguration.blendingFunction), (App)FloatProvider.f_146502_.fieldOf("matching_blending_function_chance").forGetter(archConfiguration -> archConfiguration.matchingBlendingFunctionChance), (App)FloatProvider.f_146502_.fieldOf("percentage_destroyed").forGetter(archConfiguration -> archConfiguration.percentageDestroyed), (App)NoisySphereConfig.CODEC.fieldOf("generation").forGetter(archConfiguration -> archConfiguration.sphereConfig), (App)TagKey.m_203877_((ResourceKey)Registry.f_122885_).fieldOf("allowed_biomes").orElse(EMPTY).forGetter(archConfiguration -> archConfiguration.biomeEnforcement)).apply((Applicative)builder, ArchConfiguration::new));

    public static final class Builder {
        private IntProvider height = UniformInt.m_146622_((int)35, (int)90);
        private IntProvider length = UniformInt.m_146622_((int)50, (int)250);
        private IntProvider width = UniformInt.m_146622_((int)1, (int)10);
        private NoisySphereConfig sphereConfig = new NoisySphereConfig.Builder().build();
        private SimpleWeightedRandomList<BlendingFunction> blendingFunction = SimpleWeightedRandomList.m_185862_((Object)BlendingFunction.EaseOutCubic.INSTANCE);
        private FloatProvider matchingBlendingFunctionChance = ConstantFloat.m_146458_((float)0.5f);
        private FloatProvider percentageDestroyed = UniformFloat.m_146605_((float)0.45f, (float)0.75f);
        private TagKey<Biome> biomeEnforcement = EMPTY;

        public Builder withHeight(IntProvider height) {
            this.height = height;
            return this;
        }

        public Builder withLength(IntProvider length) {
            this.length = length;
            return this;
        }

        public Builder withWidth(IntProvider width) {
            this.width = width;
            return this;
        }

        public Builder withSphereConfig(NoisySphereConfig sphereConfig) {
            this.sphereConfig = sphereConfig;
            return this;
        }

        public Builder withBiomeEnforcement(TagKey<Biome> biomeEnforcement) {
            this.biomeEnforcement = biomeEnforcement;
            return this;
        }

        public Builder withBlendingFunctionType(SimpleWeightedRandomList<BlendingFunction> blendingFunction) {
            this.blendingFunction = blendingFunction;
            return this;
        }

        public Builder withMatchingBlendingFunctionChance(FloatProvider matchingBlendingFunctionChance) {
            this.matchingBlendingFunctionChance = matchingBlendingFunctionChance;
            return this;
        }

        public Builder withPercentageDestroyed(FloatProvider percentageDestroyed) {
            this.percentageDestroyed = percentageDestroyed;
            return this;
        }

        public ArchConfiguration build() {
            return new ArchConfiguration(this.height, this.length, this.width, this.blendingFunction, this.matchingBlendingFunctionChance, this.percentageDestroyed, this.sphereConfig, this.biomeEnforcement);
        }
    }
}

