/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.math.noise.simplex.biome;

class RawOpenSimplexNoise {
    private static final double STRETCH_CONSTANT_2D = -0.211324865405187;
    private static final double SQUISH_CONSTANT_2D = 0.366025403784439;
    private static final double NORM_CONSTANT_2D = 47.0;
    private static final byte[] gradients2D = new byte[]{5, 2, 2, 5, -5, 2, -2, 5, 5, -2, 2, -5, -5, -2, -2, -5};
    private static final byte[] gradients3D = new byte[]{-11, 4, 4, -4, 11, 4, -4, 4, 11, 11, 4, 4, 4, 11, 4, 4, 4, 11, -11, -4, 4, -4, -11, 4, -4, -4, 11, 11, -4, 4, 4, -11, 4, 4, -4, 11, -11, 4, -4, -4, 11, -4, -4, 4, -11, 11, 4, -4, 4, 11, -4, 4, 4, -11, -11, -4, -4, -4, -11, -4, -4, -4, -11, 11, -4, -4, 4, -11, -4, 4, -4, -11};
    private final short[] perm = new short[256];
    private final short[] permGradIndex3D = new short[256];

    public RawOpenSimplexNoise(long seed) {
        int i;
        short[] source = new short[256];
        for (i = 0; i < 256; i = (int)((short)(i + 1))) {
            source[i] = i;
        }
        seed = seed * 6364136223846793005L + 1442695040888963407L;
        seed = seed * 6364136223846793005L + 1442695040888963407L;
        seed = seed * 6364136223846793005L + 1442695040888963407L;
        for (i = 255; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            this.permGradIndex3D[i] = (short)(this.perm[i] % (gradients3D.length / 3) * 3);
            source[r] = source[i];
        }
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    public double sample(double x, double y) {
        double attn_ext;
        double dy_ext;
        double dx_ext;
        int ysv_ext;
        int xsv_ext;
        double dy2;
        double dx2;
        double attn2;
        double stretchOffset = (x + y) * -0.211324865405187;
        double xs = x + stretchOffset;
        double ys = y + stretchOffset;
        int xsb = RawOpenSimplexNoise.fastFloor(xs);
        int ysb = RawOpenSimplexNoise.fastFloor(ys);
        double squishOffset = (double)(xsb + ysb) * 0.366025403784439;
        double xb = (double)xsb + squishOffset;
        double yb = (double)ysb + squishOffset;
        double xins = xs - (double)xsb;
        double yins = ys - (double)ysb;
        double inSum = xins + yins;
        double dx0 = x - xb;
        double dy0 = y - yb;
        double value = 0.0;
        double dx1 = dx0 - 1.0 - 0.366025403784439;
        double dy1 = dy0 - 0.0 - 0.366025403784439;
        double attn1 = 2.0 - dx1 * dx1 - dy1 * dy1;
        if (attn1 > 0.0) {
            attn1 *= attn1;
            value += attn1 * attn1 * this.extrapolate(xsb + 1, ysb + 0, dx1, dy1);
        }
        if ((attn2 = 2.0 - (dx2 = dx0 - 0.0 - 0.366025403784439) * dx2 - (dy2 = dy0 - 1.0 - 0.366025403784439) * dy2) > 0.0) {
            attn2 *= attn2;
            value += attn2 * attn2 * this.extrapolate(xsb + 0, ysb + 1, dx2, dy2);
        }
        if (inSum <= 1.0) {
            zins = 1.0 - inSum;
            if (zins > xins || zins > yins) {
                if (xins > yins) {
                    xsv_ext = xsb + 1;
                    ysv_ext = ysb - 1;
                    dx_ext = dx0 - 1.0;
                    dy_ext = dy0 + 1.0;
                } else {
                    xsv_ext = xsb - 1;
                    ysv_ext = ysb + 1;
                    dx_ext = dx0 + 1.0;
                    dy_ext = dy0 - 1.0;
                }
            } else {
                xsv_ext = xsb + 1;
                ysv_ext = ysb + 1;
                dx_ext = dx0 - 1.0 - 0.732050807568878;
                dy_ext = dy0 - 1.0 - 0.732050807568878;
            }
        } else {
            zins = 2.0 - inSum;
            if (zins < xins || zins < yins) {
                if (xins > yins) {
                    xsv_ext = xsb + 2;
                    ysv_ext = ysb + 0;
                    dx_ext = dx0 - 2.0 - 0.732050807568878;
                    dy_ext = dy0 + 0.0 - 0.732050807568878;
                } else {
                    xsv_ext = xsb + 0;
                    ysv_ext = ysb + 2;
                    dx_ext = dx0 + 0.0 - 0.732050807568878;
                    dy_ext = dy0 - 2.0 - 0.732050807568878;
                }
            } else {
                dx_ext = dx0;
                dy_ext = dy0;
                xsv_ext = xsb;
                ysv_ext = ysb;
            }
            ++xsb;
            ++ysb;
            dx0 = dx0 - 1.0 - 0.732050807568878;
            dy0 = dy0 - 1.0 - 0.732050807568878;
        }
        double attn0 = 2.0 - dx0 * dx0 - dy0 * dy0;
        if (attn0 > 0.0) {
            attn0 *= attn0;
            value += attn0 * attn0 * this.extrapolate(xsb, ysb, dx0, dy0);
        }
        if ((attn_ext = 2.0 - dx_ext * dx_ext - dy_ext * dy_ext) > 0.0) {
            attn_ext *= attn_ext;
            value += attn_ext * attn_ext * this.extrapolate(xsv_ext, ysv_ext, dx_ext, dy_ext);
        }
        return value / 47.0;
    }

    private double extrapolate(int xsb, int ysb, double dx, double dy) {
        int index = this.perm[this.perm[xsb & 0xFF] + ysb & 0xFF] & 0xE;
        return (double)gradients2D[index] * dx + (double)gradients2D[index + 1] * dy;
    }
}

