/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.math.noise.cubic;

public class CubicNoise {
    private static final int RND_A = 134775813;
    private static final int RND_B = 1103515245;
    private final int seed;
    private final int period;

    public CubicNoise(int seed) {
        this.seed = seed;
        this.period = Integer.MAX_VALUE;
    }

    private static double randomize(int seed, int x, int y) {
        return (double)(((x ^ y) * 134775813 ^ seed + x) * (1103515245 * x << 16 ^ 1103515245 * y - 134775813)) / 2.147483647E9;
    }

    private static int tile(int coordinate, int period) {
        return coordinate % period;
    }

    public static double cerp(double a, double b, double c, double d, double x) {
        double p = d - c - (a - b);
        return x * (x * (x * p + (a - b - p)) + (c - a)) + b;
    }

    public double sample2D(double x) {
        int xi = (int)Math.floor(x);
        double lerp = x - (double)xi;
        return CubicNoise.cerp(CubicNoise.randomize(this.seed, CubicNoise.tile(xi - 1, this.period), 0), CubicNoise.randomize(this.seed, CubicNoise.tile(xi, this.period), 0), CubicNoise.randomize(this.seed, CubicNoise.tile(xi + 1, this.period), 0), CubicNoise.randomize(this.seed, CubicNoise.tile(xi + 2, this.period), 0), lerp) * 0.5 + 0.25;
    }

    public double sample2D(double x, double y) {
        int xi = (int)Math.floor(x);
        double lerpx = x - (double)xi;
        int yi = (int)Math.floor(y);
        double lerpy = y - (double)yi;
        double[] xSamples = new double[4];
        for (int i = 0; i < 4; ++i) {
            xSamples[i] = CubicNoise.cerp(CubicNoise.randomize(this.seed, CubicNoise.tile(xi - 1, this.period), CubicNoise.tile(yi - 1 + i, this.period)), CubicNoise.randomize(this.seed, CubicNoise.tile(xi, this.period), CubicNoise.tile(yi - 1 + i, this.period)), CubicNoise.randomize(this.seed, CubicNoise.tile(xi + 1, this.period), CubicNoise.tile(yi - 1 + i, this.period)), CubicNoise.randomize(this.seed, CubicNoise.tile(xi + 2, this.period), CubicNoise.tile(yi - 1 + i, this.period)), lerpx);
        }
        return CubicNoise.cerp(xSamples[0], xSamples[1], xSamples[2], xSamples[3], lerpy) * 0.5 + 0.25;
    }
}

