/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen.overworld.giantflowers.util;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.common.world.feature.config.GiantFlowerConfig;
import potionstudios.byg.common.world.feature.gen.FeatureGenUtil;

public abstract class BYGAbstractGiantFlowerFeature<T extends GiantFlowerConfig>
extends Feature<T> {
    public BYGAbstractGiantFlowerFeature(Codec<T> configCodec) {
        super(configCodec);
    }

    public static boolean canStemPlaceHere(LevelSimulatedReader worldReader, BlockPos blockPos) {
        return worldReader.m_7433_(blockPos, BlockBehaviour.BlockStateBase::m_60795_) || FeatureGenUtil.isPlant(worldReader, blockPos);
    }

    public boolean isAnotherFlowerHere(LevelSimulatedReader worldReader, BlockPos blockPos) {
        return worldReader.m_7433_(blockPos, state -> state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_));
    }

    public void placeStem(BlockState stemBlockState, WorldGenLevel reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.canStemPlaceHere((LevelSimulatedReader)reader, pos)) {
            this.setFinalBlockState((LevelWriter)reader, pos, stemBlockState);
        }
    }

    public void placeStemBranch(BlockState stemBlockState, WorldGenLevel reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.canStemPlaceHere((LevelSimulatedReader)reader, pos)) {
            this.setFinalBlockState((LevelWriter)reader, pos, stemBlockState);
        }
    }

    public void placePetal(BlockState petalBlockState, WorldGenLevel reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.isAir((LevelSimulatedReader)reader, pos)) {
            this.setFinalBlockState((LevelWriter)reader, pos, petalBlockState);
        }
    }

    public void placePetal2(BlockState petalBlockState, WorldGenLevel reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.isAir((LevelSimulatedReader)reader, pos)) {
            this.setFinalBlockState((LevelWriter)reader, pos, petalBlockState);
        }
    }

    public void placePollen(BlockState pollenBlockState, WorldGenLevel reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.isAir((LevelSimulatedReader)reader, pos)) {
            this.setFinalBlockState((LevelWriter)reader, pos, pollenBlockState);
        }
    }

    public boolean canGiantFlowerGrowHere(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_) || state.m_60795_() || state.m_60767_() == Material.f_76300_ || state.m_60767_() == Material.f_76302_ || state.m_60767_() == Material.f_76301_ || state.m_60767_() == Material.f_76274_ || state.m_60767_() == Material.f_76314_);
    }

    public static boolean isAir(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }

    public static boolean isDesiredGroundwDirtTag(LevelSimulatedReader reader, BlockPos pos, Block ... desiredGroundBlock) {
        return reader.m_7433_(pos, state -> {
            Block block = state.m_60734_();
            int n = 0;
            Block[] blockArray = desiredGroundBlock;
            int n2 = blockArray.length;
            if (n < n2) {
                Block block1 = blockArray[n];
                return state.m_204336_(BlockTags.f_144274_) || block == block1;
            }
            return state.m_204336_(BlockTags.f_144274_);
        });
    }

    public boolean doesFlowerHaveSpaceToGrow(LevelSimulatedReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xDistance, int zDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canGiantFlowerGrowHere(reader, (BlockPos)mutable.m_122178_(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canGiantFlowerGrowHere(reader, (BlockPos)mutable.m_122178_(trunkPos.m_123341_(), trunkPos.m_123342_() + yOffSet, trunkPos.m_123343_()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xDistance; xOffset <= xDistance; ++xOffset) {
                    for (int zOffset = -zDistance; zOffset <= zDistance; ++zOffset) {
                        if (this.canGiantFlowerGrowHere(reader, (BlockPos)mutable.m_122178_(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherFlowerNearby(LevelSimulatedReader reader, BlockPos pos, int treeHeight, int distance, boolean isSapling) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherFlowerHere(reader, (BlockPos)mutable.m_122178_(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public final void setFinalBlockState(LevelWriter worldIn, BlockPos pos, BlockState blockState) {
        this.setBlockStateWithoutUpdates(worldIn, pos, blockState);
    }

    public void setBlockStateWithoutUpdates(LevelWriter worldWriter, BlockPos blockPos, BlockState blockState) {
        worldWriter.m_7731_(blockPos, blockState, 2);
    }

    protected void m_5974_(LevelWriter worldIn, BlockPos pos, BlockState state) {
        this.setBlockStateWithoutUpdates(worldIn, pos, state);
    }

    public boolean m_142674_(FeaturePlaceContext<T> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (GiantFlowerConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel worldIn, ChunkGenerator generator, Random rand, BlockPos pos, T config) {
        return this.placeFlower(worldIn, rand, pos, ((GiantFlowerConfig)config).isPlacementForced(), config);
    }

    protected abstract boolean placeFlower(WorldGenLevel var1, Random var2, BlockPos var3, boolean var4, T var5);
}

