/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import potionstudios.byg.common.world.feature.config.NoisySphereConfig;
import potionstudios.byg.common.world.math.noise.fastnoise.FastNoise;

public class NoisyCaveSphereWater
extends Feature<NoisySphereConfig> {
    public static FastNoise fastNoise;
    protected static long seed;

    public NoisyCaveSphereWater(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoisySphereConfig> featurePlaceContext) {
        return this.place(featurePlaceContext.m_159774_(), featurePlaceContext.m_159775_(), featurePlaceContext.m_159776_(), featurePlaceContext.m_159777_(), (NoisySphereConfig)featurePlaceContext.m_159778_());
    }

    public boolean place(WorldGenLevel world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoisySphereConfig config) {
        NoisyCaveSphereWater.setSeed(world.m_7328_());
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)position);
        BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos().m_122190_((Vec3i)mutable);
        int stackHeight = config.stackHeight().m_142270_(random);
        NoisySphereConfig.RadiusSettings radiusSettings = config.radiusSettings();
        int xRadius = radiusSettings.xRadius().m_142270_(random);
        int yRadius = radiusSettings.yRadius().m_142270_(random);
        int zRadius = radiusSettings.zRadius().m_142270_(random);
        fastNoise.SetFrequency(config.noiseFrequency());
        double radiusDivisorPerStack = config.radiusDivisorPerStack();
        for (int stackIDX = 0; stackIDX < stackHeight; ++stackIDX) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                for (int z = -zRadius; z <= zRadius; ++z) {
                    for (int y = -yRadius; y <= 0; ++y) {
                        mutable.m_142448_(world.m_6924_(Heightmap.Types.OCEAN_FLOOR_WG, mutable.m_123341_() + x, mutable.m_123343_() + z));
                        mutable2.m_122190_((Vec3i)mutable).m_122184_(x, y, z);
                        ChunkAccess chunk = world.m_46865_((BlockPos)mutable2);
                        double equationResult = Math.pow(x, 2.0) / Math.pow(xRadius, 2.0) + Math.pow(y, 2.0) / Math.pow(yRadius, 2.0) + Math.pow(z, 2.0) / Math.pow(zRadius, 2.0);
                        double threshold = 1.0 + 0.7 * (double)fastNoise.GetNoise(mutable2.m_123341_(), mutable2.m_123342_(), mutable2.m_123343_());
                        if (equationResult >= threshold || !world.m_8055_((BlockPos)mutable2).m_60815_()) continue;
                        int bitIndex = mutable2.m_123341_() & 0xF | (mutable2.m_123343_() & 0xF) << 4 | mutable2.m_123342_() << 8;
                        world.m_7731_((BlockPos)mutable2, Blocks.f_49990_.m_49966_(), 2);
                        world.m_186469_((BlockPos)mutable2, (Fluid)Fluids.f_76193_, 0);
                    }
                    xRadius = (int)((double)xRadius / radiusDivisorPerStack);
                    yRadius = (int)((double)yRadius / radiusDivisorPerStack);
                    zRadius = (int)((double)zRadius / radiusDivisorPerStack);
                }
            }
        }
        return true;
    }

    public static void setSeed(long worldSeed) {
        if (seed != worldSeed || fastNoise == null) {
            fastNoise = new FastNoise((int)worldSeed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            fastNoise.SetFrequency(0.09f);
            seed = worldSeed;
        }
    }
}

