/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.gen;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import potionstudios.byg.util.BlockHelper;

public class FeatureGenUtil {
    public static boolean isPlant(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_204336_(BlockTags.f_13035_) || state.m_60767_() == Material.f_76274_ || state.m_60767_() == Material.f_76300_ || state.m_60767_() == Material.f_76302_ || state.m_60767_() == Material.f_76301_ || state.m_60767_() == Material.f_76303_);
    }

    public static boolean isTerrainOrRock(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_204336_(BlockTags.f_13061_) || state.m_60767_() == Material.f_76278_ || state.m_204336_(BlockTags.f_13061_) || state.m_60767_() == Material.f_76314_ || state.m_204336_(BlockTags.f_13029_) || state.m_60767_() == Material.f_76317_ || state.m_60734_() == Blocks.f_50440_);
    }

    public static boolean isAir(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, BlockBehaviour.BlockStateBase::m_60795_);
    }

    public static boolean isAirInRange(LevelSimulatedReader world, BlockPos pos, int xRange, int yRange, int zRange) {
        return FeatureGenUtil.isAirInRange(world, pos, xRange, yRange, zRange, xRange, yRange, zRange);
    }

    public static boolean isAirInRange(LevelSimulatedReader world, BlockPos pos, int xNegRange, int yNegRange, int zNegRange, int xPosRange, int yPosRange, int zPosRange) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = -xNegRange; x <= xPosRange; ++x) {
            for (int y = -yNegRange; y <= yPosRange; ++y) {
                for (int z = -zNegRange; z <= zPosRange; ++z) {
                    mutable.m_122190_((Vec3i)pos.m_142082_(x, y, z));
                    if (FeatureGenUtil.isAir(world, (BlockPos)mutable)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void transformMutable(BlockPos.MutableBlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                pos.m_142443_(-pos.m_123343_());
                break;
            }
            case FRONT_BACK: {
                pos.m_142451_(-pos.m_123341_());
            }
        }
        switch (rotationIn) {
            case COUNTERCLOCKWISE_90: {
                pos.m_122178_(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_());
                break;
            }
            case CLOCKWISE_90: {
                pos.m_122178_(-pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
                break;
            }
            case CLOCKWISE_180: {
                pos.m_122178_(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
            }
        }
    }

    public static BlockPos transform(BlockPos pos, Mirror mirrorIn, Rotation rotationIn) {
        int posX = pos.m_123341_();
        int posZ = pos.m_123343_();
        boolean mirror = true;
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                posZ = -posZ;
                break;
            }
            case FRONT_BACK: {
                posX = -posX;
                break;
            }
            default: {
                mirror = false;
            }
        }
        return switch (rotationIn) {
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(posZ, pos.m_123342_(), -posX);
            case Rotation.CLOCKWISE_90 -> new BlockPos(-posZ, pos.m_123342_(), posX);
            case Rotation.CLOCKWISE_180 -> new BlockPos(-posX, pos.m_123342_(), -posZ);
            default -> mirror ? new BlockPos(posX, pos.m_123342_(), posZ) : pos;
        };
    }

    public static BlockPos extractOffset(BlockPos startPos, BlockPos blockPos) {
        return blockPos instanceof BlockPos.MutableBlockPos ? new BlockPos.MutableBlockPos(startPos.m_123341_() - blockPos.m_123341_(), blockPos.m_123342_(), startPos.m_123343_() - blockPos.m_123343_()) : new BlockPos(startPos.m_123341_() - blockPos.m_123341_(), blockPos.m_123342_(), startPos.m_123343_() - blockPos.m_123343_());
    }

    public static int getYOnSurface(LevelReader world, int x, int z) {
        return world.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
    }

    public static int getYOnSurfaceWG(LevelReader world, int x, int z) {
        return world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, x, z);
    }

    public static BlockPos getPosOnSurface(LevelReader world, BlockPos pos) {
        return world.m_5452_(Heightmap.Types.WORLD_SURFACE, pos);
    }

    public static BlockPos getPosOnSurfaceWG(LevelReader world, BlockPos pos) {
        return world.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos);
    }

    public static BlockPos getPosOnSurfaceRaycast(LevelReader world, BlockPos pos) {
        return FeatureGenUtil.getPosOnSurfaceRaycast(world, pos, 256);
    }

    public static BlockPos getPosOnSurfaceRaycast(LevelReader world, BlockPos pos, int dist) {
        int h = BlockHelper.downRay(world, pos, dist);
        return pos.m_6625_(h);
    }
}

