/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.gui.biomepedia.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import potionstudios.byg.BYG;
import potionstudios.byg.client.gui.biomepedia.screen.AbstractBiomepediaScreen;
import potionstudios.byg.client.gui.biomepedia.screen.BiomeListScreen;
import potionstudios.byg.client.gui.biomepedia.screen.ItemsViewScreen;
import potionstudios.byg.client.gui.biomepedia.widget.ScrollableText;
import potionstudios.byg.client.gui.biomepedia.widget.WidgetList;
import potionstudios.byg.mixin.access.client.ScreenAccess;
import potionstudios.byg.util.ModPlatform;

public class BiomepediaHomeScreen
extends AbstractBiomepediaScreen {
    public static final String PATREON_URL = "https://www.patreon.com/biomesyougo";
    public static final String GITHUB_ISSUES_URL = "https://github.com/AOCAWOL/BYG/issues";
    public static final String TRANSLATIONS_URL = "https://crowdin.com/project/oh-the-biomes-youll-go";
    public static final ResourceLocation BIOMEPEDIA_LOCATION = BYG.createLocation("textures/gui/biomepedia_book_gui.png");
    public static final String DOWNLOAD_URL = ModPlatform.INSTANCE.curseForgeURL();
    public static final ResourceLocation BOOK_TEXTURES = new ResourceLocation("byg", "textures/gui/biomepedia.png");
    int toolTipMaxWidth;
    int textStartHeight;
    private ScrollableText scrollableText;
    private WidgetList widgets;

    public BiomepediaHomeScreen(Component $$0) {
        super($$0);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.toolTipMaxWidth = 124;
        TranslatableComponent textComponent = new TranslatableComponent("biomepedia.intro");
        this.textStartHeight = this.bottomPos + 104 - 5;
        int y1 = this.topPos - 12;
        this.scrollableText = new ScrollableText((Component)textComponent, this.toolTipMaxWidth, this.textStartHeight, this.textStartHeight + 16, y1);
        this.scrollableText.m_93507_(this.leftPos + 13);
        this.m_142416_((GuiEventListener)this.scrollableText);
        int buttonWidth = 92;
        int buttonHeight = 20;
        Button blocksAndItems = new Button(0, this.topPos, buttonWidth, buttonHeight, (Component)new TranslatableComponent("biomepedia.intro.options.blocksanditems"), button -> this.f_96541_.m_91152_((Screen)new ItemsViewScreen(this)), BiomepediaHomeScreen.makeButtonToolTip((Component)new TranslatableComponent("biomepedia.intro.options.blocksanditems.hover"), this));
        Button biomes = new Button(0, this.topPos, buttonWidth, buttonHeight, (Component)new TranslatableComponent("biomepedia.intro.options.biomes"), button -> this.f_96541_.m_91152_((Screen)new BiomeListScreen(this)), BiomepediaHomeScreen.getToolTip((Component)new TranslatableComponent("biomepedia.intro.options.biomes.hover"), this));
        Button ores = new Button(0, this.topPos, buttonWidth, buttonHeight, (Component)new TranslatableComponent("biomepedia.intro.options.ores"), button -> {}, BiomepediaHomeScreen.getToolTip((Component)new TranslatableComponent("biomepedia.intro.options.ores.hover"), this));
        Button translations = new Button(0, this.topPos, buttonWidth, buttonHeight, (Component)new TranslatableComponent("biomepedia.intro.options.translate"), this.consumeLink(TRANSLATIONS_URL), BiomepediaHomeScreen.getToolTip((Component)new TranslatableComponent("biomepedia.intro.options.translate.hover"), this));
        ores.f_93623_ = false;
        Button issues = new Button(0, this.topPos, buttonWidth, buttonHeight, (Component)new TranslatableComponent("biomepedia.intro.options.issues"), this.consumeLink(GITHUB_ISSUES_URL), BiomepediaHomeScreen.makeButtonToolTip((Component)new TranslatableComponent("biomepedia.intro.options.issues.hover"), this));
        Button donate = new Button(0, this.topPos, buttonWidth, buttonHeight, (Component)new TranslatableComponent("biomepedia.intro.options.donate"), this.consumeLink(PATREON_URL), BiomepediaHomeScreen.makeButtonToolTip((Component)new TranslatableComponent("biomepedia.intro.options.donate.hover"), this));
        Button download = new Button(0, this.topPos, buttonWidth, buttonHeight, (Component)new TranslatableComponent("biomepedia.intro.options.download"), this.consumeLink(DOWNLOAD_URL), BiomepediaHomeScreen.makeButtonToolTip((Component)new TranslatableComponent("biomepedia.intro.options.download.hover"), this));
        ImmutableList buttons = ImmutableList.of((Object)blocksAndItems, (Object)biomes, (Object)ores, (Object)download, (Object)translations, (Object)issues, (Object)donate);
        int listRenderedHeight = 208 + this.bottomPos;
        this.widgets = new WidgetList((List<AbstractWidget>)buttons, buttonWidth + 9, listRenderedHeight + 20, this.bottomPos + 15, listRenderedHeight - 15, buttonHeight + 4);
        this.widgets.m_93507_(this.leftPos + 72 + buttonWidth);
        this.m_7787_((GuiEventListener)this.widgets);
    }

    @NotNull
    private static Button.OnTooltip getToolTip(Component component, Screen screen) {
        return (button, poseStack, mouseX, mouseZ) -> {
            if (!button.f_93623_) {
                screen.m_96602_(poseStack, (Component)new TranslatableComponent("biomepedia.intro.options.disabled.hover"), mouseX, mouseZ);
            } else {
                screen.m_96602_(poseStack, component, mouseX, mouseZ);
            }
        };
    }

    @NotNull
    public static Button.OnTooltip makeButtonToolTip(Component component, Screen screen) {
        return BiomepediaHomeScreen.makeButtonToolTip(component, screen, button -> button.f_93623_);
    }

    @NotNull
    public static Button.OnTooltip makeButtonToolTip(Component component, Screen screen, Predicate<Button> buttonPredicate) {
        return (button, poseStack, mouseX, mouseZ) -> {
            if (buttonPredicate.test(button)) {
                screen.m_96602_(poseStack, component, mouseX, mouseZ);
            }
        };
    }

    @NotNull
    private Button.OnPress consumeLink(String url) {
        return button -> this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                try {
                    ((ScreenAccess)((Object)this)).byg_invokeOpenLink(new URI(url));
                    this.f_96541_.m_91152_((Screen)this);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            } else {
                this.f_96541_.m_91152_((Screen)this);
            }
        }, url, false));
    }

    @Override
    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.renderBYGLogo(poseStack);
        this.widgets.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    private void renderBYGLogo(PoseStack poseStack) {
        poseStack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BOOK_TEXTURES);
        float scale = 3.35f;
        poseStack.m_85841_(scale, scale, 0.0f);
        float toolTipMaxWidthScaled = (float)this.toolTipMaxWidth / scale;
        this.m_93228_(poseStack, Math.round(((float)this.leftPos + toolTipMaxWidthScaled / 2.0f) / scale) + 1, Math.round((float)this.bottomPos / scale + 4.0f / scale), 20, 224, 32, 32);
        poseStack.m_85849_();
    }
}

