/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.config.serializers;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import potionstudios.byg.client.config.configeditor.ConfigCollectionEntry;
import potionstudios.byg.client.config.configeditor.ConfigEditEntry;
import potionstudios.byg.client.config.configeditor.ConfigPrimitiveEntry;
import potionstudios.byg.client.config.serializers.ConfigEntriesSerializer;

public class TomlConfigEntriesSerializer
implements ConfigEntriesSerializer<CommentedConfig> {
    private final Object configOrList;
    private final String path;

    private TomlConfigEntriesSerializer(Object configOrList, String path) {
        this.configOrList = configOrList;
        this.path = path;
    }

    @Override
    public List<ConfigEditEntry<?>> createEntries(Screen screen, String shownPath) {
        ArrayList entries = new ArrayList();
        Object object2 = this.configOrList;
        if (object2 instanceof CommentedConfig) {
            CommentedConfig commentedConfig = (CommentedConfig)object2;
            commentedConfig.valueMap().forEach((key, object) -> {
                String comment;
                String string = comment = commentedConfig.getComment(key) == null ? "" : commentedConfig.getComment(key);
                if (object instanceof CommentedConfig) {
                    CommentedConfig asCommentedConfig = (CommentedConfig)object;
                    entries.add(new ConfigCollectionEntry(screen, (String)key, new TomlConfigEntriesSerializer(asCommentedConfig, shownPath), (Component)new TextComponent(comment)));
                } else if (object instanceof List) {
                    List list = (List)object;
                    entries.add(new ConfigCollectionEntry(screen, (String)key, new TomlConfigEntriesSerializer(list, shownPath), (Component)new TextComponent(comment)));
                } else {
                    ConfigPrimitiveEntry<?> configPrimitiveEntry = ConfigEntriesSerializer.makePrimitiveEntry(key, object, screen, comment);
                    if (configPrimitiveEntry != null) {
                        entries.add(configPrimitiveEntry);
                    }
                }
            });
        } else {
            object2 = this.configOrList;
            if (object2 instanceof List) {
                List array = (List)object2;
                for (int i = 0; i < array.size(); ++i) {
                    Object element = array.get(i);
                    if (element instanceof CommentedConfig) {
                        CommentedConfig commentedConfig = (CommentedConfig)element;
                        entries.add(new ConfigCollectionEntry(screen, Integer.toString(i + 1), new TomlConfigEntriesSerializer(commentedConfig, shownPath)));
                        continue;
                    }
                    if (element instanceof List) {
                        List list = (List)element;
                        entries.add(new ConfigCollectionEntry(screen, Integer.toString(i + 1), new TomlConfigEntriesSerializer(list, shownPath)));
                        continue;
                    }
                    ConfigPrimitiveEntry<?> configPrimitiveEntry = ConfigEntriesSerializer.makePrimitiveEntry(Integer.toString(i + 1), element, screen);
                    if (configPrimitiveEntry == null) continue;
                    entries.add(configPrimitiveEntry);
                }
            }
        }
        return entries;
    }

    @Override
    public void saveFile(Path configFilePath) {
        TomlWriter writer = new TomlWriter();
        Object object = this.configOrList;
        if (object instanceof UnmodifiableConfig) {
            UnmodifiableConfig unmodifiableConfig = (UnmodifiableConfig)object;
            writer.write(unmodifiableConfig, configFilePath, WritingMode.REPLACE);
        } else {
            throw new IllegalStateException("Trying to save incorrect object type");
        }
    }

    @Override
    public String save(List<? extends ConfigEditEntry<?>> entries) {
        Object errorsAsString;
        StringBuilder errors = new StringBuilder();
        Object object = this.configOrList;
        if (object instanceof CommentedConfig) {
            CommentedConfig asJsonObject = (CommentedConfig)object;
            for (ConfigEditEntry<?> child : entries) {
                try {
                    Object value = child.getValue();
                    if (value == null || !PRIMITIVE_TYPES.contains(value.getClass())) continue;
                    asJsonObject.set(child.key, value);
                }
                catch (Exception e) {
                    errors.append(child.key).append(": ").append(e.getMessage()).append("\n");
                }
            }
        } else {
            object = this.configOrList;
            if (object instanceof List) {
                List asJsonArray = (List)object;
                for (ConfigEditEntry<?> child : entries) {
                    try {
                        Object value = child.getValue();
                        if (value == null || !PRIMITIVE_TYPES.contains(value.getClass())) continue;
                        int index = Integer.parseInt(child.key) - 1;
                        asJsonArray.remove(index);
                        asJsonArray.add(index, child.getValue());
                    }
                    catch (Exception e) {
                        errors.append(child.key).append(": ").append(e.getMessage()).append("\n");
                    }
                }
            }
        }
        if (!((String)(errorsAsString = errors.toString())).isEmpty()) {
            errorsAsString = "Errors were found:\n" + (String)errorsAsString;
        }
        return errorsAsString;
    }

    public static TomlConfigEntriesSerializer fromPath(Path path) throws IOException {
        String fileName = path.toFile().getName();
        if (fileName.endsWith(".toml")) {
            CommentedFileConfig builtConfig = CommentedFileConfig.of((Path)path);
            builtConfig.load();
            return new TomlConfigEntriesSerializer(builtConfig, path.toString());
        }
        throw new IOException(String.format("\"%s\" does not end with the \".toml\" file extension.", path.toString()));
    }

    @Override
    public ConfigEntriesSerializer<CommentedConfig> makeMap(String shownPath) {
        return new TomlConfigEntriesSerializer(CommentedConfig.inMemory(), shownPath);
    }

    @Override
    public ConfigEntriesSerializer<CommentedConfig> makeList(String shownPath) {
        return new TomlConfigEntriesSerializer(new ArrayList(), shownPath);
    }

    @Override
    public String path() {
        return this.path;
    }
}

