/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.config.serializers;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import potionstudios.byg.client.config.configeditor.ConfigCollectionEntry;
import potionstudios.byg.client.config.configeditor.ConfigEditEntry;
import potionstudios.byg.client.config.configeditor.ConfigPrimitiveEntry;
import potionstudios.byg.client.config.serializers.ConfigEntriesSerializer;
import potionstudios.byg.shadow.blue.endless.jankson.JsonArray;
import potionstudios.byg.shadow.blue.endless.jankson.JsonElement;
import potionstudios.byg.shadow.blue.endless.jankson.JsonObject;
import potionstudios.byg.shadow.blue.endless.jankson.JsonPrimitive;
import potionstudios.byg.shadow.blue.endless.jankson.api.SyntaxError;
import potionstudios.byg.util.jankson.JanksonUtil;

public class JanksonConfigEntriesSerializer
implements ConfigEntriesSerializer<JsonElement> {
    private final JsonElement jsonElement;
    private final String path;

    private JanksonConfigEntriesSerializer(JsonElement jsonElement, String path) {
        this.jsonElement = jsonElement;
        this.path = path;
    }

    @Override
    public List<ConfigEditEntry<?>> createEntries(Screen screen, String shownPath) {
        ArrayList fileEditEntries = new ArrayList();
        JsonElement jsonElement = this.jsonElement;
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            jsonObject.forEach((key, element) -> {
                String comment;
                String string = comment = jsonObject.getComment((String)key) == null ? "" : jsonObject.getComment((String)key);
                if (element instanceof JsonPrimitive) {
                    JsonPrimitive primitive = (JsonPrimitive)element;
                    Object value = primitive.getValue();
                    ConfigPrimitiveEntry<?> configPrimitiveEntry = ConfigEntriesSerializer.makePrimitiveEntry(key, value, screen, comment);
                    if (configPrimitiveEntry != null) {
                        fileEditEntries.add(configPrimitiveEntry);
                    }
                } else if (element instanceof JsonArray) {
                    JsonArray jsonArray = (JsonArray)element;
                    fileEditEntries.add(new ConfigCollectionEntry(screen, (String)key, new JanksonConfigEntriesSerializer(jsonArray, shownPath), (Component)new TextComponent(comment)));
                } else if (element instanceof JsonObject) {
                    JsonObject jsonObject1 = (JsonObject)element;
                    fileEditEntries.add(new ConfigCollectionEntry(screen, (String)key, new JanksonConfigEntriesSerializer(jsonObject1, shownPath), (Component)new TextComponent(comment)));
                }
            });
        } else {
            jsonElement = this.jsonElement;
            if (jsonElement instanceof JsonArray) {
                JsonArray array = (JsonArray)jsonElement;
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement element2 = array.get(i);
                    if (element2 instanceof JsonPrimitive) {
                        JsonPrimitive primitive = (JsonPrimitive)element2;
                        ConfigPrimitiveEntry<?> configPrimitiveEntry = ConfigEntriesSerializer.makePrimitiveEntry(Integer.toString(i + 1), primitive.getValue(), screen);
                        if (configPrimitiveEntry == null) continue;
                        fileEditEntries.add(configPrimitiveEntry);
                        continue;
                    }
                    if (element2 instanceof JsonObject) {
                        JsonObject jsonObject = (JsonObject)element2;
                        fileEditEntries.add(new ConfigCollectionEntry(screen, Integer.toString(i + 1), new JanksonConfigEntriesSerializer(jsonObject, shownPath)));
                        continue;
                    }
                    if (!(element2 instanceof JsonArray)) continue;
                    JsonArray jsonArray = (JsonArray)element2;
                    fileEditEntries.add(new ConfigCollectionEntry(screen, Integer.toString(i + 1), new JanksonConfigEntriesSerializer(jsonArray, shownPath)));
                }
            }
        }
        return fileEditEntries;
    }

    @Override
    public void saveFile(Path configFile) throws IOException {
        Files.write(configFile, this.jsonElement.toJson(JanksonUtil.JSON_GRAMMAR).getBytes(), new OpenOption[0]);
    }

    @Override
    public String save(List<? extends ConfigEditEntry<?>> fileEditEntries) {
        Object errorsAsString;
        StringBuilder errors = new StringBuilder();
        Object object = this.jsonElement;
        if (object instanceof JsonObject) {
            JsonObject asJsonObject = (JsonObject)object;
            for (ConfigEditEntry configEditEntry : fileEditEntries) {
                try {
                    Object value = configEditEntry.getValue();
                    if (value == null || !PRIMITIVE_TYPES.contains(value.getClass())) continue;
                    asJsonObject.put(configEditEntry.key, new JsonPrimitive(value));
                }
                catch (Exception e) {
                    errors.append(configEditEntry.key).append(": ").append(e.getMessage()).append("\n");
                }
            }
        } else {
            object = this.jsonElement;
            if (object instanceof JsonArray) {
                JsonArray asJsonArray = (JsonArray)object;
                for (ConfigEditEntry<?> configEditEntry : fileEditEntries) {
                    try {
                        Object value = configEditEntry.getValue();
                        if (value == null || !PRIMITIVE_TYPES.contains(value.getClass())) continue;
                        int index = Integer.parseInt(configEditEntry.key) - 1;
                        if (index < asJsonArray.size()) {
                            asJsonArray.remove(index);
                        }
                        asJsonArray.add(index, new JsonPrimitive(value));
                    }
                    catch (Exception e) {
                        errors.append(configEditEntry.key).append(": ").append(e.getMessage()).append("\n");
                    }
                }
            }
        }
        if (!((String)(errorsAsString = errors.toString())).isEmpty()) {
            errorsAsString = "Errors were found:\n" + (String)errorsAsString;
        }
        return errorsAsString;
    }

    public static JanksonConfigEntriesSerializer fromPath(Path path) throws IOException, SyntaxError {
        JsonObject jsonElement1;
        String fileName = path.toFile().getName();
        if (fileName.endsWith(".json") || fileName.endsWith(".json5")) {
            jsonElement1 = JanksonUtil.JANKSON.load(path.toFile());
        } else {
            throw new IOException(String.format("\"%s\" does not end with \".json\" or \".json5\" file extension.", path.toString()));
        }
        return new JanksonConfigEntriesSerializer(jsonElement1, path.toString());
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public ConfigEntriesSerializer<JsonElement> makeMap(String shownPath) {
        return new JanksonConfigEntriesSerializer(new JsonObject(), shownPath);
    }

    @Override
    public ConfigEntriesSerializer<JsonElement> makeList(String shownPath) {
        return new JanksonConfigEntriesSerializer(new JsonArray(), shownPath);
    }
}

