/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.client.config.filebrowser;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import potionstudios.byg.client.config.ScreenPosition;

public abstract class KeyCommentToolTipEntry<T>
extends ContainerObjectSelectionList.Entry<KeyCommentToolTipEntry<T>> {
    public final Screen parent;
    public final String key;
    public final int maxKeyWidth;
    public final int maxCommentWidth;
    private final Component comment;
    protected final ScreenPosition keyScreenPosition = new ScreenPosition();
    public final List<Component> toolTip = new ArrayList<Component>();
    private int cachedWidth = 0;
    public boolean renderToolTip;

    public KeyCommentToolTipEntry(Screen parent, String key) {
        this(parent, key, (Component)new TextComponent(""));
    }

    public KeyCommentToolTipEntry(Screen parent, String key, String comment) {
        this(parent, key, (Component)new TextComponent(comment));
    }

    public KeyCommentToolTipEntry(Screen parent, String key, Component comment) {
        this.parent = parent;
        this.key = "..." + key.substring(Math.max(key.length() - 35, 0));
        this.maxKeyWidth = Minecraft.m_91087_().f_91062_.m_92895_(this.key);
        this.maxCommentWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)comment);
        this.comment = comment;
    }

    public void m_6311_(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
        float x = (float)(pLeft - this.getRowLength()) + (float)pWidth;
        float y = pTop + pHeight / 2 - 4;
        this.keyScreenPosition.x = x;
        this.keyScreenPosition.y = y;
        boolean reloadsCache = this.toolTipCacheReload(pWidth, pIsMouseOver);
        if (reloadsCache) {
            this.makeAndCacheConfigCommentToolTip(pWidth);
        }
        Minecraft.m_91087_().f_91062_.m_92883_(pPoseStack, this.key, this.keyScreenPosition.x, this.keyScreenPosition.y, 0xFFFFFF);
    }

    public boolean toolTipCacheReload(int pWidth, boolean pIsMouseOver) {
        return pIsMouseOver || this.comment.getString().isBlank() || this.cachedWidth != pWidth;
    }

    private void makeAndCacheConfigCommentToolTip(int pWidth) {
        this.toolTip.clear();
        for (String lines : this.comment.getString().split("\n")) {
            StringBuilder comment = new StringBuilder();
            for (String word : lines.split(" ")) {
                if (word.isBlank() && !lines.isBlank()) continue;
                word = word.trim();
                if (Minecraft.m_91087_().f_91062_.m_92895_(comment.toString()) < pWidth) {
                    comment.append(word).append(" ");
                    continue;
                }
                this.toolTip.add((Component)new TextComponent(comment.toString()));
                comment = new StringBuilder(word).append(" ");
            }
            if (comment.isEmpty()) continue;
            this.toolTip.add((Component)new TextComponent(comment.toString()));
        }
        this.cachedWidth = pWidth;
    }

    public void tick() {
    }

    public int getRowLength() {
        return this.maxKeyWidth;
    }
}

